/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells;

import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.spells.SpellFactory;
import com.verdantartifice.primalmagick.common.spells.mods.ISpellMod;
import com.verdantartifice.primalmagick.common.spells.mods.QuickenSpellMod;
import com.verdantartifice.primalmagick.common.spells.payloads.ISpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.ISpellVehicle;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class SpellPackage
implements INBTSerializable<CompoundTag> {
    protected String name = "";
    protected ISpellVehicle vehicle = null;
    protected ISpellPayload payload = null;
    protected ISpellMod primaryMod = null;
    protected ISpellMod secondaryMod = null;

    public SpellPackage() {
    }

    public SpellPackage(String name) {
        this.setName(name);
    }

    public SpellPackage(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Nonnull
    public Component getName() {
        return Component.m_237113_((String)this.name).m_130938_(this.getRarity().getStyleModifier());
    }

    public void setName(@Nullable String name) {
        if (name != null) {
            this.name = name;
        }
    }

    @Nullable
    public ISpellVehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(@Nullable ISpellVehicle vehicle) {
        this.vehicle = vehicle;
    }

    @Nullable
    public ISpellPayload getPayload() {
        return this.payload;
    }

    public void setPayload(@Nullable ISpellPayload payload) {
        this.payload = payload;
    }

    @Nullable
    public ISpellMod getPrimaryMod() {
        return this.primaryMod;
    }

    public void setPrimaryMod(@Nullable ISpellMod primaryMod) {
        this.primaryMod = primaryMod;
    }

    @Nullable
    public ISpellMod getSecondaryMod() {
        return this.secondaryMod;
    }

    public void setSecondaryMod(@Nullable ISpellMod secondaryMod) {
        this.secondaryMod = secondaryMod;
    }

    public boolean isValid() {
        return this.vehicle != null && this.vehicle.isActive() && this.payload != null && this.payload.isActive() && this.name != null && !this.name.isEmpty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        if (this.name != null) {
            nbt.m_128359_("SpellName", this.name);
        }
        if (this.vehicle != null) {
            nbt.m_128365_("SpellVehicle", this.vehicle.serializeNBT());
        }
        if (this.payload != null) {
            nbt.m_128365_("SpellPayload", this.payload.serializeNBT());
        }
        if (this.primaryMod != null) {
            nbt.m_128365_("PrimaryMod", this.primaryMod.serializeNBT());
        }
        if (this.secondaryMod != null) {
            nbt.m_128365_("SecondaryMod", this.secondaryMod.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.name = nbt.m_128461_("SpellName");
        this.vehicle = nbt.m_128441_("SpellVehicle") ? SpellFactory.getVehicleFromNBT(nbt.m_128469_("SpellVehicle")) : null;
        this.payload = nbt.m_128441_("SpellPayload") ? SpellFactory.getPayloadFromNBT(nbt.m_128469_("SpellPayload")) : null;
        this.primaryMod = nbt.m_128441_("PrimaryMod") ? SpellFactory.getModFromNBT(nbt.m_128469_("PrimaryMod")) : null;
        this.secondaryMod = nbt.m_128441_("SecondaryMod") ? SpellFactory.getModFromNBT(nbt.m_128469_("SecondaryMod")) : null;
    }

    public int getCooldownTicks() {
        int retVal = 30;
        QuickenSpellMod quickenMod = this.getMod(QuickenSpellMod.class, "haste");
        if (quickenMod != null) {
            retVal -= 5 * quickenMod.getPropertyValue("haste");
        }
        return Mth.m_14045_((int)retVal, (int)0, (int)30);
    }

    @Nonnull
    public SourceList getManaCost() {
        if (this.payload == null) {
            return SourceList.EMPTY;
        }
        int baseManaCost = this.payload.getBaseManaCost();
        if (baseManaCost == 0) {
            return SourceList.EMPTY;
        }
        Source source = this.payload.getSource();
        int baseModifier = 0;
        int multiplier = 1;
        if (this.vehicle != null) {
            baseModifier += this.vehicle.getBaseManaCostModifier();
            multiplier *= this.vehicle.getManaCostMultiplier();
        }
        if (this.primaryMod != null) {
            baseModifier += this.primaryMod.getBaseManaCostModifier();
            multiplier *= this.primaryMod.getManaCostMultiplier();
        }
        if (this.secondaryMod != null) {
            baseModifier += this.secondaryMod.getBaseManaCostModifier();
            multiplier *= this.secondaryMod.getManaCostMultiplier();
        }
        return SourceList.EMPTY.add(source, (baseManaCost + baseModifier) * multiplier);
    }

    public void cast(Level world, LivingEntity caster, ItemStack spellSource) {
        if (this.payload != null) {
            this.payload.playSounds(world, caster.m_20183_());
        }
        if (this.vehicle != null) {
            if (caster instanceof Player) {
                StatsManager.incrementValue((Player)caster, StatsPM.SPELLS_CAST);
            }
            this.vehicle.execute(this, world, caster, spellSource);
        }
    }

    public int getActiveModCount() {
        int retVal = 0;
        if (this.primaryMod != null && this.primaryMod.isActive()) {
            ++retVal;
        }
        if (this.secondaryMod != null && this.secondaryMod.isActive()) {
            ++retVal;
        }
        return retVal;
    }

    @Nonnull
    public Rarity getRarity() {
        int mods = this.getActiveModCount();
        switch (mods) {
            case 2: {
                return Rarity.EPIC;
            }
            case 1: {
                return Rarity.RARE;
            }
        }
        return Rarity.UNCOMMON;
    }

    @Nullable
    public <T extends ISpellMod> T getMod(Class<T> clazz, String tiebreakerProperty) {
        ISpellMod secondary;
        ISpellMod primary = clazz.isInstance(this.primaryMod) ? (ISpellMod)clazz.cast(this.primaryMod) : null;
        ISpellMod iSpellMod = secondary = clazz.isInstance(this.secondaryMod) ? (ISpellMod)clazz.cast(this.secondaryMod) : null;
        if (primary != null && secondary != null) {
            return (T)(secondary.getPropertyValue(tiebreakerProperty) > primary.getPropertyValue(tiebreakerProperty) ? secondary : primary);
        }
        if (primary != null) {
            return (T)primary;
        }
        return (T)secondary;
    }

    @Nullable
    public ResourceLocation getIcon() {
        if (this.payload != null) {
            return this.payload.getSource().getImage();
        }
        return null;
    }
}

