/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.mods;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BurstSpellMod
extends AbstractSpellMod {
    public static final String TYPE = "burst";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_MOD_BURST.get()).compoundKey();

    public BurstSpellMod() {
    }

    public BurstSpellMod(int radius, int power) {
        this.getProperty("radius").setValue(radius);
        this.getProperty("power").setValue(power);
    }

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    protected Map<String, SpellProperty> initProperties() {
        Map<String, SpellProperty> propMap = super.initProperties();
        propMap.put("radius", new SpellProperty("radius", "spells.primalmagick.property.radius", 1, 5));
        propMap.put("power", new SpellProperty("power", "spells.primalmagick.property.power", 0, 5));
        return propMap;
    }

    @Override
    public int getBaseManaCostModifier() {
        return this.getPropertyValue("power");
    }

    @Override
    public int getManaCostMultiplier() {
        int radius = this.getPropertyValue("radius");
        return 1 + radius * radius;
    }

    @Override
    protected String getModType() {
        return TYPE;
    }

    @Nonnull
    public Set<HitResult> getBurstTargets(HitResult origin, SpellPackage spell, @Nullable ItemStack spellSource, Level world) {
        HashSet<HitResult> retVal = new HashSet<HitResult>();
        HashSet<BlockPos> affectedBlocks = new HashSet<BlockPos>();
        Vec3 hitVec = origin.m_82450_();
        BlockPos hitPos = BlockPos.m_274446_((Position)hitVec);
        int radius = this.getRadiusBlocks();
        int power = this.getBlastPower(spell, spellSource);
        double sqRadius = radius * radius;
        int searchRadius = radius + 1;
        Explosion explosion = new Explosion(world, null, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, (float)power, false, Explosion.BlockInteraction.KEEP);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    Vec3 dirVec = new Vec3((double)i / 15.0 * 2.0 - 1.0, (double)j / 15.0 * 2.0 - 1.0, (double)k / 15.0 * 2.0 - 1.0).m_82541_();
                    Vec3 curVec = new Vec3(hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_);
                    float remainingPower = power;
                    while (remainingPower >= 0.0f && curVec.m_82557_(hitVec) < sqRadius) {
                        BlockPos curPos = BlockPos.m_274446_((Position)curVec);
                        if (affectedBlocks.add(curPos)) {
                            Vec3 relVec = hitVec.m_82546_(curVec);
                            Direction dir = Direction.m_122366_((double)relVec.f_82479_, (double)relVec.f_82480_, (double)relVec.f_82481_);
                            retVal.add((HitResult)new BlockHitResult(curVec, dir, curPos, false));
                        }
                        BlockState blockState = world.m_8055_(curPos);
                        FluidState fluidState = world.m_6425_(curPos);
                        if (!blockState.m_60795_() || !fluidState.m_76178_()) {
                            float resistance = Math.max(blockState.getExplosionResistance((BlockGetter)world, curPos, explosion), fluidState.getExplosionResistance((BlockGetter)world, curPos, explosion));
                            remainingPower -= (resistance + 0.3f) * 0.3f;
                        }
                        curVec = curVec.m_82549_(dirVec.m_82490_(0.3));
                    }
                }
            }
        }
        AABB aabb = new AABB(hitPos).m_82400_((double)searchRadius);
        List entities = world.m_6249_((Entity)null, aabb, e -> !e.m_5833_());
        for (Entity entity : entities) {
            if (!(origin.m_82450_().m_82557_(entity.m_20182_()) <= sqRadius)) continue;
            retVal.add((HitResult)new EntityHitResult(entity));
        }
        return retVal;
    }

    protected int getRadiusBlocks() {
        return this.getPropertyValue("radius");
    }

    protected int getBlastPower(SpellPackage spell, ItemStack spellSource) {
        return 5 + 3 * this.getModdedPropertyValue("power", spell, spellSource);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource) {
        return Component.m_237110_((String)("spells.primalmagick.mod." + this.getModType() + ".detail_tooltip"), (Object[])new Object[]{this.getRadiusBlocks(), this.getBlastPower(spell, spellSource)});
    }
}

