/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.mods;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import com.verdantartifice.primalmagick.common.util.VectorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ForkSpellMod
extends AbstractSpellMod {
    public static final String TYPE = "fork";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_MOD_FORK.get()).compoundKey();

    public ForkSpellMod() {
    }

    public ForkSpellMod(int forks, int precision) {
        this.getProperty("forks").setValue(forks);
        this.getProperty("precision").setValue(precision);
    }

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    protected Map<String, SpellProperty> initProperties() {
        Map<String, SpellProperty> propMap = super.initProperties();
        propMap.put("forks", new SpellProperty("forks", "spells.primalmagick.property.forks", 2, 5));
        propMap.put("precision", new SpellProperty("precision", "spells.primalmagick.property.precision", 0, 5));
        return propMap;
    }

    @Override
    public int getBaseManaCostModifier() {
        return 0;
    }

    @Override
    public int getManaCostMultiplier() {
        int forks = this.getPropertyValue("forks");
        int precision = this.getPropertyValue("precision");
        return 1 + forks * forks + precision * precision;
    }

    @Override
    protected String getModType() {
        return TYPE;
    }

    @Nonnull
    public List<Vec3> getDirectionUnitVectors(@Nonnull Vec3 dir, @Nonnull RandomSource rng) {
        ArrayList<Vec3> retVal = new ArrayList<Vec3>();
        Vec3 normDir = dir.m_82541_();
        int forks = this.getForkCount();
        int degrees = this.getSpreadDegrees();
        double offsetMagnitude = Math.tan(Math.toRadians(degrees));
        for (int index = 0; index < forks; ++index) {
            Vec3 offset = VectorUtils.getRandomOrthogonalUnitVector(normDir, rng).m_82490_(offsetMagnitude * rng.m_188500_());
            retVal.add(normDir.m_82549_(offset));
        }
        return retVal;
    }

    protected int getForkCount() {
        return this.getPropertyValue("forks");
    }

    protected int getSpreadDegrees() {
        int precision = this.getPropertyValue("precision");
        return 10 + 15 * (5 - precision);
    }

    protected String getSpreadDegreesText() {
        return this.getSpreadDegrees() + "\u00b0";
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource) {
        return Component.m_237110_((String)("spells.primalmagick.mod." + this.getModType() + ".detail_tooltip"), (Object[])new Object[]{this.getForkCount(), this.getSpreadDegreesText()});
    }
}

