/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.mods;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.mods.AbstractSpellMod;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class MineSpellMod
extends AbstractSpellMod {
    public static final String TYPE = "mine";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_MOD_MINE.get()).compoundKey();

    public MineSpellMod() {
    }

    public MineSpellMod(int duration) {
        this.getProperty("duration").setValue(duration);
    }

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    protected Map<String, SpellProperty> initProperties() {
        Map<String, SpellProperty> propMap = super.initProperties();
        propMap.put("duration", new SpellProperty("duration", "spells.primalmagick.property.duration", 1, 5));
        return propMap;
    }

    @Override
    public int getBaseManaCostModifier() {
        return this.getPropertyValue("duration");
    }

    @Override
    public int getManaCostMultiplier() {
        return 1;
    }

    @Override
    protected String getModType() {
        return TYPE;
    }

    public int getDurationMinutes(SpellPackage spell, ItemStack spellSource) {
        return 4 * this.getModdedPropertyValue("duration", spell, spellSource);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource) {
        return Component.m_237110_((String)("spells.primalmagick.mod." + this.getModType() + ".detail_tooltip"), (Object[])new Object[]{this.getDurationMinutes(spell, spellSource)});
    }
}

