/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractConjureBlockSpellPayload
extends AbstractSpellPayload {
    protected final BlockState targetState;
    protected final int count;

    public AbstractConjureBlockSpellPayload(BlockState targetState) {
        this(targetState, 1);
    }

    public AbstractConjureBlockSpellPayload(BlockState targetState, int count) {
        this.targetState = targetState;
        this.count = count;
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        if (!(caster instanceof Player)) {
            return;
        }
        Player player = (Player)caster;
        if (target != null) {
            if (target.m_6662_() == HitResult.Type.BLOCK) {
                this.executeInner((BlockHitResult)target, player, world);
            } else if (target.m_6662_() == HitResult.Type.ENTITY) {
                this.executeInner(RayTraceUtils.getBlockResultFromEntityResult((EntityHitResult)target), player, world);
            }
        }
    }

    protected void executeInner(BlockHitResult blockTarget, Player player, Level world) {
        int shift;
        for (int offset = shift = this.canPlaceBlockState(player, world, targetPos = blockTarget.m_82425_()) ? 0 : 1; offset < this.count + shift; ++offset) {
            BlockPos targetPos;
            this.placeBlockState(world, targetPos.m_5484_(blockTarget.m_82434_(), offset));
        }
    }

    protected boolean canPlaceBlockState(Player player, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        boolean isSolid = state.m_280296_();
        boolean isReplaceable = state.m_247087_();
        return world.m_7966_(player, pos) && !ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)pos), (Direction)Direction.UP) && world.m_46859_(pos) || !isSolid || isReplaceable;
    }

    protected void placeBlockState(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        FluidState fluidState = world.m_6425_(pos);
        boolean isSolid = state.m_280296_();
        boolean isReplaceable = state.m_247087_();
        if (world.m_46859_(pos) || !isSolid || isReplaceable) {
            if (!(world.f_46443_ || isSolid && !isReplaceable || state.m_278721_())) {
                world.m_46961_(pos, true);
            }
            BlockState newState = this.targetState;
            if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
                newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
            } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
            }
            if (fluidState.m_164512_((Fluid)Fluids.f_76193_) && newState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE);
            }
            world.m_7731_(pos, newState, 3);
        }
    }
}

