/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractConjureFluidSpellPayload
extends AbstractSpellPayload {
    protected final FlowingFluid fluid;

    public AbstractConjureFluidSpellPayload(FlowingFluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        if (!(caster instanceof Player)) {
            return;
        }
        Player player = (Player)caster;
        if (target != null) {
            BlockHitResult blockTarget;
            ItemStack stack = this.getSimulatedItemStack((Fluid)this.fluid);
            if (target.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockTarget2 = (BlockHitResult)target;
                BlockPos targetPos = blockTarget2.m_82425_();
                if (world.m_7966_(player, targetPos) && player.m_36204_(targetPos, blockTarget2.m_82434_(), stack)) {
                    BlockState state = world.m_8055_(targetPos);
                    BlockPos placePos = state.m_60734_() instanceof LiquidBlockContainer && this.fluid == Fluids.f_76193_ ? targetPos : targetPos.m_121945_(blockTarget2.m_82434_());
                    this.placeFluid(player, world, placePos, blockTarget2);
                }
            } else if (target.m_6662_() == HitResult.Type.ENTITY && world.m_7966_(player, (blockTarget = RayTraceUtils.getBlockResultFromEntityResult((EntityHitResult)target)).m_82425_()) && player.m_36204_(blockTarget.m_82425_(), blockTarget.m_82434_(), stack)) {
                this.placeFluid(player, world, blockTarget.m_82425_(), blockTarget);
            }
        }
    }

    protected ItemStack getSimulatedItemStack(@Nonnull Fluid fluid) {
        if (fluid.m_205067_(FluidTags.f_13131_)) {
            return new ItemStack((ItemLike)Items.f_42447_);
        }
        if (fluid.m_205067_(FluidTags.f_13132_)) {
            return new ItemStack((ItemLike)Items.f_42448_);
        }
        return ItemStack.f_41583_;
    }

    protected void placeFluid(Player player, Level world, BlockPos pos, BlockHitResult blockTarget) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        boolean isSolid = state.m_280296_();
        boolean isReplaceable = state.m_247087_();
        if (world.m_46859_(pos) || !isSolid || isReplaceable || block instanceof LiquidBlockContainer && ((LiquidBlockContainer)block).m_6044_((BlockGetter)world, pos, state, (Fluid)this.fluid)) {
            if (world.m_6042_().f_63857_() && this.fluid.m_205067_(FluidTags.f_13131_)) {
                return;
            }
            if (block instanceof LiquidBlockContainer && this.fluid == Fluids.f_76193_) {
                ((LiquidBlockContainer)block).m_7361_((LevelAccessor)world, pos, state, this.fluid.m_76068_(false));
            } else {
                if (!(world.f_46443_ || isSolid && !isReplaceable || state.m_278721_())) {
                    world.m_46961_(pos, true);
                }
                world.m_7731_(pos, this.fluid.m_76145_().m_76188_(), 11);
            }
        } else if (blockTarget != null) {
            this.placeFluid(player, world, blockTarget.m_82425_().m_121945_(blockTarget.m_82434_()), null);
        }
    }
}

