/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.damagesource.DamageSourcesPM;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractDamageSpellPayload
extends AbstractSpellPayload {
    public AbstractDamageSpellPayload() {
    }

    public AbstractDamageSpellPayload(int power) {
        this.getProperty("power").setValue(power);
    }

    @Override
    protected Map<String, SpellProperty> initProperties() {
        Map<String, SpellProperty> propMap = super.initProperties();
        propMap.put("power", new SpellProperty("power", "spells.primalmagick.property.power", 1, 5));
        return propMap;
    }

    protected float getBaseDamage(SpellPackage spell, ItemStack spellSource) {
        return 4.0f + 3.0f * (float)this.getModdedPropertyValue("power", spell, spellSource);
    }

    protected float getTotalDamage(Entity target, SpellPackage spell, @Nullable ItemStack spellSource) {
        float damage = this.getBaseDamage(spell, spellSource);
        if (target instanceof Player) {
            damage *= 0.5f;
        }
        return damage;
    }

    protected DamageSource getDamageSource(LivingEntity source, SpellPackage spell, Entity projectileEntity) {
        if (projectileEntity != null) {
            return DamageSourcesPM.sorcery(source.m_9236_(), this.getSource(), projectileEntity, source);
        }
        if (spell.getVehicle().isIndirect()) {
            return DamageSourcesPM.sorcery(source.m_9236_(), this.getSource(), null, source);
        }
        return DamageSourcesPM.sorcery(source.m_9236_(), this.getSource(), source);
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        EntityHitResult entityTarget;
        if (target != null && target.m_6662_() == HitResult.Type.ENTITY && (entityTarget = (EntityHitResult)target).m_82443_() != null) {
            entityTarget.m_82443_().m_6469_(this.getDamageSource(caster, spell, projectileEntity), this.getTotalDamage(entityTarget.m_82443_(), spell, spellSource));
            if (caster != null) {
                caster.m_21335_(entityTarget.m_82443_());
            }
        }
        this.applySecondaryEffects(target, burstPoint, spell, world, caster, spellSource);
    }

    protected void applySecondaryEffects(@Nullable HitResult target, @Nullable Vec3 burstPoint, @Nonnull SpellPackage spell, @Nonnull Level world, @Nonnull LivingEntity caster, @Nullable ItemStack spellSource) {
    }
}

