/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.misc.EntitySwapper;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractPolymorphSpellPayload
extends AbstractSpellPayload {
    public AbstractPolymorphSpellPayload() {
    }

    public AbstractPolymorphSpellPayload(int duration) {
        this.getProperty("duration").setValue(duration);
    }

    @Override
    protected Map<String, SpellProperty> initProperties() {
        Map<String, SpellProperty> propMap = super.initProperties();
        propMap.put("duration", new SpellProperty("duration", "spells.primalmagick.property.duration", 1, 5));
        return propMap;
    }

    protected abstract EntityType<?> getNewEntityType();

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        EntityHitResult entityTarget;
        if (target != null && target.m_6662_() == HitResult.Type.ENTITY && SpellManager.canPolymorph((entityTarget = (EntityHitResult)target).m_82443_().m_6095_())) {
            UUID entityId = entityTarget.m_82443_().m_20148_();
            CompoundTag originalData = entityTarget.m_82443_().m_20240_(new CompoundTag());
            int ticks = 20 * this.getDurationSeconds(spell, spellSource);
            EntitySwapper.enqueue(world, new EntitySwapper(entityId, this.getNewEntityType(), originalData, Optional.of(ticks), 0));
        }
    }

    @Override
    public Source getSource() {
        return Source.MOON;
    }

    @Override
    public int getBaseManaCost() {
        return 5 * this.getPropertyValue("duration");
    }

    protected abstract SoundEvent getCastSoundEvent();

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.m_5594_(null, origin, this.getCastSoundEvent(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.f_46441_.m_188583_() * 0.05));
    }

    protected int getDurationSeconds(SpellPackage spell, ItemStack spellSource) {
        return 6 * this.getModdedPropertyValue("duration", spell, spellSource);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource) {
        return Component.m_237110_((String)("spells.primalmagick.payload." + this.getPayloadType() + ".detail_tooltip"), (Object[])new Object[]{DECIMAL_FORMATTER.format(this.getDurationSeconds(spell, spellSource))});
    }
}

