/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.mods.AmplifySpellMod;
import com.verdantartifice.primalmagick.common.spells.payloads.ISpellPayload;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public abstract class AbstractSpellPayload
implements ISpellPayload {
    protected static final DecimalFormat DECIMAL_FORMATTER = new DecimalFormat("#######.##");
    protected final Map<String, SpellProperty> properties = this.initProperties();

    protected abstract String getPayloadType();

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("PayloadType", this.getPayloadType());
        for (Map.Entry<String, SpellProperty> entry : this.properties.entrySet()) {
            nbt.m_128405_(entry.getKey(), entry.getValue().getValue());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (Map.Entry<String, SpellProperty> entry : this.properties.entrySet()) {
            entry.getValue().setValue(nbt.m_128451_(entry.getKey()));
        }
    }

    @Nonnull
    protected Map<String, SpellProperty> initProperties() {
        return new HashMap<String, SpellProperty>();
    }

    @Override
    public List<SpellProperty> getProperties() {
        return this.properties.values().stream().sorted((p1, p2) -> p1.getName().compareTo(p2.getName())).collect(Collectors.toList());
    }

    @Override
    public SpellProperty getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public int getPropertyValue(String name) {
        return this.properties.containsKey(name) ? this.properties.get(name).getValue() : 0;
    }

    public int getModdedPropertyValue(@Nonnull String name, @Nonnull SpellPackage spell, @Nullable ItemStack spellSource) {
        int retVal = this.getPropertyValue(name);
        if (retVal > 0 && ("power".equals(name) || "duration".equals(name))) {
            int enchLevel;
            AmplifySpellMod ampMod = spell.getMod(AmplifySpellMod.class, "power");
            if (ampMod != null) {
                retVal += ampMod.getPropertyValue("power");
            }
            if (spellSource != null && (enchLevel = spellSource.getEnchantmentLevel((Enchantment)EnchantmentsPM.SPELL_POWER.get())) > 0) {
                retVal += enchLevel;
            }
        }
        return retVal;
    }

    @Override
    public Component getTypeName() {
        return Component.m_237115_((String)("spells.primalmagick.payload." + this.getPayloadType() + ".type"));
    }

    @Override
    public Component getDefaultNamePiece() {
        return Component.m_237115_((String)("spells.primalmagick.payload." + this.getPayloadType() + ".default_name"));
    }

    @Override
    public boolean isActive() {
        return true;
    }
}

