/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractDamageSpellPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BloodDamageSpellPayload
extends AbstractDamageSpellPayload {
    public static final String TYPE = "blood_damage";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_PAYLOAD_BLOOD.get()).compoundKey();

    public BloodDamageSpellPayload() {
    }

    public BloodDamageSpellPayload(int power) {
        super(power);
    }

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    public Source getSource() {
        return Source.BLOOD;
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.m_5594_(null, origin, (SoundEvent)SoundsPM.BLOOD.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.f_46441_.m_188583_() * 0.05));
    }

    @Override
    protected float getBaseDamage(SpellPackage spell, ItemStack spellSource) {
        return 3.0f + 2.0f * (float)this.getModdedPropertyValue("power", spell, spellSource);
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }

    @Override
    public int getBaseManaCost() {
        int power = this.getPropertyValue("power");
        return (1 << Math.max(0, power - 1)) + (1 << Math.max(0, power - 1) >> 1);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource) {
        return Component.m_237110_((String)("spells.primalmagick.payload." + this.getPayloadType() + ".detail_tooltip"), (Object[])new Object[]{DECIMAL_FORMATTER.format(this.getBaseDamage(spell, spellSource))});
    }
}

