/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ConjureAnimalSpellPayload
extends AbstractSpellPayload {
    public static final String TYPE = "conjure_animal";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_PAYLOAD_CONJURE_ANIMAL.get()).compoundKey();
    protected static final WeightedRandomBag<EntityType<?>> LAND_ANIMALS = (WeightedRandomBag)Util.m_137469_(new WeightedRandomBag(), bag -> {
        bag.add(EntityType.f_20549_, 2.0);
        bag.add(EntityType.f_20553_, 5.0);
        bag.add(EntityType.f_20555_, 10.0);
        bag.add(EntityType.f_20557_, 10.0);
        bag.add(EntityType.f_20560_, 2.0);
        bag.add(EntityType.f_20452_, 5.0);
        bag.add(EntityType.f_147035_, 5.0);
        bag.add(EntityType.f_20457_, 2.0);
        bag.add(EntityType.f_20504_, 1.0);
        bag.add(EntityType.f_20505_, 5.0);
        bag.add(EntityType.f_20508_, 2.0);
        bag.add(EntityType.f_20510_, 10.0);
        bag.add(EntityType.f_20517_, 5.0);
        bag.add(EntityType.f_20520_, 10.0);
        bag.add(EntityType.f_20490_, 5.0);
    });
    protected static final WeightedRandomBag<EntityType<?>> WATER_ANIMALS = (WeightedRandomBag)Util.m_137469_(new WeightedRandomBag(), bag -> {
        bag.add(EntityType.f_147039_, 2.0);
        bag.add(EntityType.f_20556_, 10.0);
        bag.add(EntityType.f_147034_, 2.0);
        bag.add(EntityType.f_20516_, 10.0);
        bag.add(EntityType.f_20519_, 10.0);
        bag.add(EntityType.f_20480_, 5.0);
        bag.add(EntityType.f_20489_, 10.0);
        bag.add(EntityType.f_20490_, 5.0);
    });

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        if (burstPoint != null) {
            return;
        }
        if (target.m_6662_() == HitResult.Type.BLOCK) {
            this.placeRandomAnimal(world, (BlockHitResult)target);
        } else if (target.m_6662_() == HitResult.Type.ENTITY) {
            this.placeRandomAnimal(world, RayTraceUtils.getBlockResultFromEntityResult((EntityHitResult)target));
        }
    }

    protected void placeRandomAnimal(Level world, BlockHitResult blockTarget) {
        EntityType<?> entityType;
        BlockPos pos = blockTarget.m_82425_().m_121945_(blockTarget.m_82434_());
        FluidState state = world.m_6425_(pos);
        EntityType<?> entityType2 = entityType = state.m_205070_(FluidTags.f_13131_) && state.m_76170_() ? WATER_ANIMALS.getRandom(world.f_46441_) : LAND_ANIMALS.getRandom(world.f_46441_);
        if (entityType != null && world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            entityType.m_20592_(serverWorld, (ItemStack)null, (Player)null, pos, MobSpawnType.MOB_SUMMONED, false, false);
        }
    }

    @Override
    public Source getSource() {
        return Source.BLOOD;
    }

    @Override
    public int getBaseManaCost() {
        return 100;
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.m_5594_(null, origin, (SoundEvent)SoundsPM.EGG_CRACK.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.f_46441_.m_188583_() * 0.05));
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }
}

