/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DrainSoulSpellPayload
extends AbstractSpellPayload {
    public static final String TYPE = "drain_soul";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_PAYLOAD_DRAIN_SOUL.get()).compoundKey();

    public DrainSoulSpellPayload() {
    }

    public DrainSoulSpellPayload(int duration) {
        this.getProperty("duration").setValue(duration);
    }

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    protected Map<String, SpellProperty> initProperties() {
        Map<String, SpellProperty> propMap = super.initProperties();
        propMap.put("duration", new SpellProperty("duration", "spells.primalmagick.property.duration", 1, 5));
        return propMap;
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        EntityHitResult entityTarget;
        if (target != null && target.m_6662_() == HitResult.Type.ENTITY && (entityTarget = (EntityHitResult)target).m_82443_() instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityTarget.m_82443_();
            int ticks = 20 * this.getDurationSeconds(spell, spellSource);
            entity.m_7292_(new MobEffectInstance((MobEffect)EffectsPM.DRAIN_SOUL.get(), ticks));
        }
    }

    @Override
    public Source getSource() {
        return Source.INFERNAL;
    }

    @Override
    public int getBaseManaCost() {
        return 5 * this.getPropertyValue("duration");
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.m_5594_(null, origin, SoundEvents.f_11738_, SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.f_46441_.m_188583_() * 0.05));
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }

    protected int getDurationSeconds(SpellPackage spell, ItemStack spellSource) {
        return 3 * this.getModdedPropertyValue("duration", spell, spellSource);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource) {
        return Component.m_237110_((String)("spells.primalmagick.payload." + this.getPayloadType() + ".detail_tooltip"), (Object[])new Object[]{DECIMAL_FORMATTER.format(this.getDurationSeconds(spell, spellSource))});
    }
}

