/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractDamageSpellPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EarthDamageSpellPayload
extends AbstractDamageSpellPayload {
    public static final String TYPE = "earth_damage";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.BASIC_SORCERY.get()).compoundKey();

    public EarthDamageSpellPayload() {
    }

    public EarthDamageSpellPayload(int power) {
        super(power);
    }

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }

    @Override
    public Source getSource() {
        return Source.EARTH;
    }

    @Override
    protected void applySecondaryEffects(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource) {
        EntityHitResult entityTarget;
        if (target != null && target.m_6662_() == HitResult.Type.ENTITY && (entityTarget = (EntityHitResult)target).m_82443_() != null && entityTarget.m_82443_() instanceof LivingEntity) {
            Vec3 knockbackVec;
            if (entityTarget.m_82443_().equals((Object)caster)) {
                knockbackVec = caster.m_20154_().m_82490_(-1.0).m_82541_();
            } else {
                Vec3 knockbackSource = burstPoint == null || burstPoint.equals((Object)target.m_82450_()) ? caster.m_20299_(1.0f) : burstPoint;
                knockbackVec = target.m_82450_().m_82546_(knockbackSource).m_82490_(-1.0).m_82541_();
            }
            ((LivingEntity)entityTarget.m_82443_()).m_147240_((double)(0.25f * this.getTotalDamage(entityTarget.m_82443_(), spell, spellSource)), knockbackVec.f_82479_, knockbackVec.f_82481_);
        }
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.m_5594_(null, origin, (SoundEvent)SoundsPM.ROCKSLIDE.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.f_46441_.m_188583_() * 0.05));
    }

    @Override
    public int getBaseManaCost() {
        int power = this.getPropertyValue("power");
        return (1 << Math.max(0, power - 1)) + (1 << Math.max(0, power - 1) >> 1);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource) {
        return Component.m_237110_((String)("spells.primalmagick.payload." + this.getPayloadType() + ".detail_tooltip"), (Object[])new Object[]{DECIMAL_FORMATTER.format(this.getBaseDamage(spell, spellSource))});
    }
}

