/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractDamageSpellPayload;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FrostDamageSpellPayload
extends AbstractDamageSpellPayload {
    public static final String TYPE = "frost_damage";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_PAYLOAD_FROST.get()).compoundKey();

    public FrostDamageSpellPayload() {
    }

    public FrostDamageSpellPayload(int power, int duration) {
        super(power);
        this.getProperty("duration").setValue(duration);
    }

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    protected Map<String, SpellProperty> initProperties() {
        Map<String, SpellProperty> propMap = super.initProperties();
        propMap.put("duration", new SpellProperty("duration", "spells.primalmagick.property.duration", 0, 5));
        return propMap;
    }

    @Override
    public Source getSource() {
        return Source.SEA;
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.m_5594_(null, origin, (SoundEvent)SoundsPM.ICE.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.f_46441_.m_188583_() * 0.05));
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }

    @Override
    protected float getTotalDamage(Entity target, SpellPackage spell, ItemStack spellSource) {
        float retVal = super.getTotalDamage(target, spell, spellSource);
        if (target.m_6095_() == EntityType.f_20566_) {
            retVal *= 1.5f;
        }
        return retVal;
    }

    @Override
    protected void applySecondaryEffects(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource) {
        EntityHitResult entityTarget;
        int duration = this.getDurationSeconds(spell, spellSource);
        if (target != null && target.m_6662_() == HitResult.Type.ENTITY && duration > 0 && (entityTarget = (EntityHitResult)target).m_82443_() != null && entityTarget.m_82443_() instanceof LivingEntity) {
            int potency = (int)((1.0f + (float)this.getModdedPropertyValue("power", spell, spellSource)) / 3.0f);
            ((LivingEntity)entityTarget.m_82443_()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20 * duration, potency));
        }
    }

    @Override
    public int getBaseManaCost() {
        int power = this.getPropertyValue("power");
        int duration = this.getPropertyValue("duration");
        return (1 << Math.max(0, power - 1)) + (duration == 0 ? 0 : 1 << Math.max(0, duration - 1) >> 1);
    }

    protected int getDurationSeconds(SpellPackage spell, ItemStack spellSource) {
        return 2 * this.getModdedPropertyValue("duration", spell, spellSource);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource) {
        return Component.m_237110_((String)("spells.primalmagick.payload." + this.getPayloadType() + ".detail_tooltip"), (Object[])new Object[]{DECIMAL_FORMATTER.format(this.getBaseDamage(spell, spellSource)), DECIMAL_FORMATTER.format(this.getDurationSeconds(spell, spellSource))});
    }
}

