/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.damagesource.DamageSourcesPM;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class HealingSpellPayload
extends AbstractSpellPayload {
    public static final String TYPE = "healing";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_PAYLOAD_HEALING.get()).compoundKey();

    public HealingSpellPayload() {
    }

    public HealingSpellPayload(int power) {
        this.getProperty("power").setValue(power);
    }

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    protected Map<String, SpellProperty> initProperties() {
        Map<String, SpellProperty> propMap = super.initProperties();
        propMap.put("power", new SpellProperty("power", "spells.primalmagick.property.power", 1, 5));
        return propMap;
    }

    protected DamageSource getDamageSource(LivingEntity source, SpellPackage spell, Entity projectileEntity) {
        if (projectileEntity != null) {
            return DamageSourcesPM.sorcery(source.m_9236_(), this.getSource(), projectileEntity, source);
        }
        if (spell.getVehicle().isIndirect()) {
            return DamageSourcesPM.sorcery(source.m_9236_(), this.getSource(), null, source);
        }
        return DamageSourcesPM.sorcery(source.m_9236_(), this.getSource(), source);
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        EntityHitResult entityTarget;
        Entity entity;
        if (target != null && target.m_6662_() == HitResult.Type.ENTITY && (entity = (entityTarget = (EntityHitResult)target).m_82443_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (entity2.m_21222_()) {
                entity2.m_6469_(this.getDamageSource(caster, spell, projectileEntity), 1.5f * (float)this.getBaseAmount(spell, spellSource));
            } else {
                int level;
                float curHealth = entity2.m_21223_();
                float maxHealth = entity2.m_21233_();
                float healAmount = this.getBaseAmount(spell, spellSource);
                float overhealing = curHealth + healAmount - maxHealth;
                entity2.m_5634_(healAmount);
                if (overhealing > 0.0f && overhealing >= entity2.m_6103_() && (level = (int)Math.floor(overhealing / 4.0f)) > 0) {
                    entity2.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, level - 1));
                }
            }
        }
    }

    @Override
    public Source getSource() {
        return Source.SUN;
    }

    @Override
    public int getBaseManaCost() {
        int power = this.getPropertyValue("power");
        return (1 << Math.max(0, power - 1)) + (1 << Math.max(0, power - 1) >> 1);
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.m_5594_(null, origin, (SoundEvent)SoundsPM.HEAL.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.f_46441_.m_188583_() * 0.05));
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }

    protected int getBaseAmount(SpellPackage spell, ItemStack spellSource) {
        return 2 * this.getModdedPropertyValue("power", spell, spellSource);
    }

    @Override
    public Component getDetailTooltip(SpellPackage spell, ItemStack spellSource) {
        return Component.m_237110_((String)("spells.primalmagick.payload." + this.getPayloadType() + ".detail_tooltip"), (Object[])new Object[]{DECIMAL_FORMATTER.format(this.getBaseAmount(spell, spellSource))});
    }
}

