/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.payloads;

import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import com.verdantartifice.primalmagick.common.misc.BlockBreaker;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.tags.BlockTagsForgeExt;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ShearSpellPayload
extends AbstractSpellPayload {
    public static final String TYPE = "shear";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_PAYLOAD_SHEAR.get()).compoundKey();

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    public void execute(HitResult target, Vec3 burstPoint, SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource, Entity projectileEntity) {
        ItemStack fakeShears = new ItemStack((ItemLike)Items.f_42574_);
        RandomSource rand = world.f_46441_;
        int treasureLevel = spellSource.getEnchantmentLevel((Enchantment)EnchantmentsPM.TREASURE.get());
        if (caster instanceof Player) {
            Player player = (Player)caster;
            if (target.m_6662_() == HitResult.Type.ENTITY) {
                IForgeShearable shearableEntity;
                EntityHitResult entityHitResult = (EntityHitResult)target;
                Entity entity = entityHitResult.m_82443_();
                if (entity instanceof IForgeShearable && (shearableEntity = (IForgeShearable)entity).isShearable(fakeShears, world, entity.m_20183_())) {
                    List drops = shearableEntity.onSheared(player, ItemStack.f_41583_, world, entity.m_20183_(), treasureLevel);
                    drops.forEach(d -> {
                        ItemEntity ent = entity.m_5552_(d, 1.0f);
                        ent.m_20256_(ent.m_20184_().m_82520_((double)((rand.m_188501_() - rand.m_188501_()) * 0.1f), (double)(rand.m_188501_() * 0.05f), (double)((rand.m_188501_() - rand.m_188501_()) * 0.1f)));
                    });
                }
            } else if (target.m_6662_() == HitResult.Type.BLOCK) {
                Block block;
                Block action2;
                BlockHitResult blockTarget = (BlockHitResult)target;
                BlockPos pos = blockTarget.m_82425_();
                BlockState state = world.m_8055_(pos);
                UseOnContext fakeContext = new UseOnContext(world, player, InteractionHand.MAIN_HAND, fakeShears, blockTarget);
                for (Block action2 : ToolActions.DEFAULT_SHEARS_ACTIONS) {
                    BlockState modifiedState = state.getToolModifiedState(fakeContext, (ToolAction)action2, true);
                    if (modifiedState == null) continue;
                    world.m_7731_(pos, modifiedState, 11);
                    world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)modifiedState));
                    return;
                }
                action2 = state.m_60734_();
                if (action2 instanceof TripWireBlock) {
                    TripWireBlock tripwire = (TripWireBlock)action2;
                    FluidState fluid = world.m_6425_(pos);
                    world.m_7731_(pos, (BlockState)state.m_61124_((Property)TripWireBlock.f_57592_, (Comparable)Boolean.TRUE), 4);
                    world.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                    if (world.m_7731_(pos, fluid.m_76188_(), world.f_46443_ ? 11 : 3)) {
                        state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
                    }
                }
                if ((block = state.m_60734_()) instanceof BeehiveBlock) {
                    BeehiveBlock beehive = (BeehiveBlock)block;
                    if ((Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= 5) {
                        world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11697_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        BeehiveBlock.m_49600_((Level)world, (BlockPos)pos);
                        world.m_142346_((Entity)player, GameEvent.f_157781_, pos);
                        if (!CampfireBlock.m_51248_((Level)world, (BlockPos)pos)) {
                            if (beehive.m_49654_(world, pos)) {
                                beehive.m_49649_(world, pos);
                            }
                            beehive.m_49594_(world, state, pos, player, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                        } else {
                            beehive.m_49590_(world, state, pos);
                        }
                    }
                }
                if (world.m_8055_(pos).m_204336_(BlockTagsForgeExt.MINEABLE_WITH_SHEARS)) {
                    BlockBreaker breaker = new BlockBreaker.Builder().power(5.0f).target(pos, state).durability(1.0f).player(player).tool(fakeShears).fortune(treasureLevel).alwaysDrop().build();
                    BlockBreaker.schedule(world, 1, breaker);
                }
            }
        }
    }

    @Override
    public Source getSource() {
        return Source.SKY;
    }

    @Override
    public int getBaseManaCost() {
        return 5;
    }

    @Override
    public void playSounds(Level world, BlockPos origin) {
        world.m_5594_(null, origin, SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f + (float)(world.f_46441_.m_188583_() * 0.05));
    }

    @Override
    protected String getPayloadType() {
        return TYPE;
    }
}

