/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.vehicles;

import com.verdantartifice.primalmagick.common.spells.SpellManager;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.mods.ForkSpellMod;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractSpellVehicle;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractRaycastSpellVehicle
extends AbstractSpellVehicle {
    protected abstract double getReachDistance(@Nonnull LivingEntity var1);

    protected void drawFx(@Nonnull Level world, @Nonnull SpellPackage spell, Vec3 source, Vec3 target) {
    }

    @Override
    public void execute(SpellPackage spell, Level world, LivingEntity caster, ItemStack spellSource) {
        if (spell.getPayload() != null) {
            ForkSpellMod forkMod = spell.getMod(ForkSpellMod.class, "forks");
            Vec3 baseLookVector = caster.m_20252_(1.0f);
            List<Vec3> lookVectors = forkMod == null ? Arrays.asList(baseLookVector.m_82541_()) : forkMod.getDirectionUnitVectors(baseLookVector, world.f_46441_);
            double reachDistance = this.getReachDistance(caster);
            Vec3 eyePos = caster.m_20299_(1.0f);
            for (Vec3 lookVector : lookVectors) {
                Vec3 reachPos = eyePos.m_82549_(lookVector.m_82490_(reachDistance));
                AABB aabb = caster.m_20191_().m_82369_(lookVector.m_82490_(reachDistance)).m_82377_(1.0, 1.0, 1.0);
                EntityHitResult entityResult = RayTraceUtils.rayTraceEntities(world, (Entity)caster, eyePos, reachPos, aabb, testEntity -> !testEntity.m_5833_(), reachDistance * reachDistance);
                BlockHitResult blockResult = world.m_45547_(new ClipContext(eyePos, reachPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)caster));
                Object result = entityResult == null ? blockResult : (eyePos.m_82557_(entityResult.m_82450_()) <= eyePos.m_82557_(blockResult.m_82450_()) ? entityResult : blockResult);
                this.drawFx(world, spell, eyePos.m_82549_(lookVector.m_82490_(0.1)), result.m_82450_());
                SpellManager.executeSpellPayload(spell, (HitResult)result, world, caster, spellSource, true, null);
            }
        }
    }
}

