/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.vehicles;

import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.vehicles.ISpellVehicle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public abstract class AbstractSpellVehicle
implements ISpellVehicle {
    protected final Map<String, SpellProperty> properties = this.initProperties();

    protected abstract String getVehicleType();

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("VehicleType", this.getVehicleType());
        for (Map.Entry<String, SpellProperty> entry : this.properties.entrySet()) {
            nbt.m_128405_(entry.getKey(), entry.getValue().getValue());
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (Map.Entry<String, SpellProperty> entry : this.properties.entrySet()) {
            entry.getValue().setValue(nbt.m_128451_(entry.getKey()));
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public Component getTypeName() {
        return Component.m_237115_((String)("spells.primalmagick.vehicle." + this.getVehicleType() + ".type"));
    }

    @Override
    public Component getDefaultNamePiece() {
        return Component.m_237115_((String)("spells.primalmagick.vehicle." + this.getVehicleType() + ".default_name"));
    }

    @Override
    public int getBaseManaCostModifier() {
        return 0;
    }

    @Override
    public int getManaCostMultiplier() {
        return 1;
    }

    @Nonnull
    protected Map<String, SpellProperty> initProperties() {
        return new HashMap<String, SpellProperty>();
    }

    @Override
    public List<SpellProperty> getProperties() {
        return this.properties.values().stream().sorted((p1, p2) -> p1.getName().compareTo(p2.getName())).collect(Collectors.toList());
    }

    @Override
    public SpellProperty getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public int getPropertyValue(String name) {
        return this.properties.containsKey(name) ? this.properties.get(name).getValue() : 0;
    }
}

