/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.spells.vehicles;

import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellBoltPacket;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellProperty;
import com.verdantartifice.primalmagick.common.spells.vehicles.AbstractRaycastSpellVehicle;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BoltSpellVehicle
extends AbstractRaycastSpellVehicle {
    public static final String TYPE = "bolt";
    protected static final CompoundResearchKey RESEARCH = ((ResearchName)ResearchNames.SPELL_VEHICLE_BOLT.get()).compoundKey();

    public static CompoundResearchKey getResearch() {
        return RESEARCH;
    }

    @Override
    protected double getReachDistance(LivingEntity caster) {
        return this.getRangeBlocks();
    }

    @Override
    protected String getVehicleType() {
        return TYPE;
    }

    @Override
    protected Map<String, SpellProperty> initProperties() {
        Map<String, SpellProperty> propMap = super.initProperties();
        propMap.put("range", new SpellProperty("range", "spells.primalmagick.property.range", 1, 5));
        return propMap;
    }

    @Override
    public int getBaseManaCostModifier() {
        return this.getPropertyValue("range");
    }

    @Override
    protected void drawFx(Level world, SpellPackage spell, Vec3 source, Vec3 target) {
        if (spell.getPayload() != null) {
            PacketHandler.sendToAllAround(new SpellBoltPacket(source, target, spell.getPayload().getSource().getColor()), (ResourceKey<Level>)world.m_46472_(), BlockPos.m_274446_((Position)source), 64.0);
        }
    }

    protected int getRangeBlocks() {
        return 6 + 2 * this.getPropertyValue("range");
    }

    @Override
    public Component getDetailTooltip() {
        return Component.m_237110_((String)("spells.primalmagick.vehicle." + this.getVehicleType() + ".detail_tooltip"), (Object[])new Object[]{this.getRangeBlocks()});
    }

    @Override
    public boolean isIndirect() {
        return true;
    }
}

