/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.stats;

import com.verdantartifice.primalmagick.PrimalMagick;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;

public class Stat {
    protected ResourceLocation location;
    protected StatFormatter formatter;
    protected boolean hidden;
    protected boolean internal;

    protected Stat(@Nonnull ResourceLocation location, @Nonnull StatFormatter formatter, boolean hidden, boolean internal) {
        this.location = location;
        this.formatter = formatter;
        this.hidden = hidden;
        this.internal = internal;
    }

    @Nonnull
    public static Stat create(@Nonnull String name, @Nonnull StatFormatter formatter, boolean hidden) {
        return Stat.create(name, formatter, hidden, false);
    }

    @Nonnull
    public static Stat create(@Nonnull String name, @Nonnull StatFormatter formatter, boolean hidden, boolean internal) {
        Stat retVal = new Stat(PrimalMagick.resource(name), formatter, hidden, internal);
        StatsManager.registerStat(retVal);
        return retVal;
    }

    @Nonnull
    public ResourceLocation getLocation() {
        return this.location;
    }

    @Nonnull
    public StatFormatter getFormatter() {
        return this.formatter;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @Nonnull
    public String getTranslationKey() {
        return "stat." + this.location.m_135827_() + "." + this.location.m_135815_();
    }
}

