/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.stats;

import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.stats.Stat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class StatTriggers {
    private static final Map<Stat, Map<Integer, List<SimpleResearchKey>>> REGISTRY = new HashMap<Stat, Map<Integer, List<SimpleResearchKey>>>();

    public static void register(@Nullable Stat stat, int threshold, @Nonnull Optional<SimpleResearchKey> researchOpt) {
        StatTriggers.register(stat, threshold, researchOpt.orElseThrow());
    }

    public static void register(@Nullable Stat stat, int threshold, @Nullable SimpleResearchKey research) {
        if (stat != null && research != null) {
            Map statMap = REGISTRY.computeIfAbsent(stat, k -> new HashMap());
            List keyList = statMap.computeIfAbsent(threshold, k -> new ArrayList());
            keyList.add(research);
        }
    }

    public static void checkTriggers(@Nullable ServerPlayer player, @Nullable Stat stat, int value) {
        if (player != null && stat != null) {
            PrimalMagickCapabilities.getKnowledge((Player)player).ifPresent(knowledge -> {
                boolean found = false;
                Map statMap = REGISTRY.getOrDefault(stat, Collections.emptyMap());
                for (Map.Entry entry : statMap.entrySet()) {
                    if (value < (Integer)entry.getKey()) continue;
                    for (SimpleResearchKey research : (List)entry.getValue()) {
                        if (knowledge.isResearchComplete(research)) continue;
                        ResearchManager.completeResearch((Player)player, research, false);
                        found = true;
                    }
                }
                if (found) {
                    ResearchManager.scheduleSync((Player)player);
                }
            });
        }
    }
}

