/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.stats;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerStats;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatTriggers;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class StatsManager {
    protected static final Map<ResourceLocation, Stat> REGISTRY = new HashMap<ResourceLocation, Stat>();
    protected static final List<Stat> DISPLAY_STATS = new ArrayList<Stat>();
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.m_20148_());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.m_20148_());
        }
    }

    public static Set<ResourceLocation> getStatLocations() {
        return Collections.unmodifiableSet(REGISTRY.keySet());
    }

    public static List<Stat> getDisplayStats() {
        return Collections.unmodifiableList(DISPLAY_STATS);
    }

    public static boolean registerStat(@Nullable Stat stat) {
        if (stat != null) {
            REGISTRY.put(stat.getLocation(), stat);
            if (stat.isInternal()) {
                return true;
            }
            return DISPLAY_STATS.add(stat);
        }
        return false;
    }

    public static Stat getStat(@Nullable ResourceLocation loc) {
        return REGISTRY.get(loc);
    }

    public static int getValue(@Nullable Player player, @Nullable Stat stat) {
        IPlayerStats stats;
        if (player != null && (stats = PrimalMagickCapabilities.getStats(player)) != null) {
            return stats.getValue(stat);
        }
        return 0;
    }

    @Nonnull
    public static Component getFormattedValue(@Nullable Player player, @Nullable Stat stat) {
        return Component.m_237113_((String)stat.getFormatter().m_12886_(StatsManager.getValue(player, stat)));
    }

    public static void incrementValue(@Nullable Player player, @Nullable Stat stat) {
        StatsManager.incrementValue(player, stat, 1);
    }

    public static void incrementValue(@Nullable Player player, @Nullable Stat stat, int delta) {
        StatsManager.setValue(player, stat, delta + StatsManager.getValue(player, stat));
    }

    public static void setValue(@Nullable Player player, @Nullable Stat stat, int value) {
        ServerPlayer spe;
        IPlayerStats stats;
        if (player instanceof ServerPlayer && (stats = PrimalMagickCapabilities.getStats((Player)(spe = (ServerPlayer)player))) != null) {
            stats.setValue(stat, value);
            StatsManager.scheduleSync((Player)spe);
            StatTriggers.checkTriggers(spe, stat, value);
        }
    }

    public static void setValueIfMax(@Nullable Player player, @Nullable Stat stat, int newVal) {
        if (newVal > StatsManager.getValue(player, stat)) {
            StatsManager.setValue(player, stat, newVal);
        }
    }

    public static void discoverShrine(@Nullable Player player, @Nullable Source shrineSource, @Nullable BlockPos shrinePos) {
        if (player instanceof ServerPlayer && shrineSource != null && shrinePos != null) {
            Stat stat = StatsManager.getShrineStatForSource(shrineSource);
            ServerPlayer spe = (ServerPlayer)player;
            IPlayerStats stats = PrimalMagickCapabilities.getStats((Player)spe);
            if (stat != null && stats != null && !stats.isLocationDiscovered(shrinePos)) {
                int value = 1 + stats.getValue(stat);
                stats.setLocationDiscovered(shrinePos);
                stats.setValue(stat, value);
                StatsManager.scheduleSync((Player)spe);
                StatTriggers.checkTriggers(spe, stat, value);
            }
        }
    }

    @Nullable
    protected static Stat getShrineStatForSource(@Nonnull Source source) {
        if (source.equals(Source.EARTH)) {
            return StatsPM.SHRINE_FOUND_EARTH;
        }
        if (source.equals(Source.SEA)) {
            return StatsPM.SHRINE_FOUND_SEA;
        }
        if (source.equals(Source.SKY)) {
            return StatsPM.SHRINE_FOUND_SKY;
        }
        if (source.equals(Source.SUN)) {
            return StatsPM.SHRINE_FOUND_SUN;
        }
        if (source.equals(Source.MOON)) {
            return StatsPM.SHRINE_FOUND_MOON;
        }
        return null;
    }
}

