/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class AbstractProjectMaterial
implements INBTSerializable<CompoundTag> {
    protected boolean selected = false;
    protected double weight;
    protected double bonusReward;
    protected CompoundResearchKey requiredResearch;

    protected AbstractProjectMaterial() {
    }

    public CompoundTag serializeNBT() {
        CompoundTag retVal = new CompoundTag();
        retVal.m_128359_("MaterialType", this.getMaterialType());
        retVal.m_128379_("Selected", this.isSelected());
        retVal.m_128347_("Weight", this.getWeight());
        retVal.m_128347_("BonusReward", this.bonusReward);
        if (this.requiredResearch != null) {
            retVal.m_128359_("RequiredResearch", this.getRequiredResearch().toString());
        }
        return retVal;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.selected = nbt.m_128471_("Selected");
        this.weight = nbt.m_128459_("Weight");
        this.bonusReward = nbt.m_128459_("BonusReward");
        this.requiredResearch = nbt.m_128441_("RequiredResearch") ? CompoundResearchKey.parse(nbt.m_128461_("RequiredResearch")) : null;
    }

    protected abstract String getMaterialType();

    public abstract boolean isSatisfied(Player var1, Set<Block> var2);

    public abstract boolean consume(Player var1);

    public abstract boolean isConsumed();

    public abstract void toNetwork(FriendlyByteBuf var1);

    public boolean isSelected() {
        return this.selected;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getBonusReward() {
        return this.bonusReward;
    }

    @Nullable
    public CompoundResearchKey getRequiredResearch() {
        return this.requiredResearch;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public void setBonusReward(double bonus) {
        this.bonusReward = bonus;
    }

    public void setRequiredResearch(@Nonnull CompoundResearchKey key) {
        this.requiredResearch = key.copy();
    }

    public boolean isAllowedInProject(ServerPlayer player) {
        return this.hasRequiredResearch((Player)player);
    }

    public boolean hasRequiredResearch(Player player) {
        if (this.requiredResearch == null) {
            return true;
        }
        return this.requiredResearch.isKnownByStrict(player);
    }

    public abstract AbstractProjectMaterial copy();

    public int hashCode() {
        return Objects.hash(this.bonusReward, this.requiredResearch, this.selected, this.weight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProjectMaterial other = (AbstractProjectMaterial)obj;
        return Double.doubleToLongBits(this.bonusReward) == Double.doubleToLongBits(other.bonusReward) && Objects.equals(this.requiredResearch, other.requiredResearch) && this.selected == other.selected && Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
    }
}

