/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.theorycrafting.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.IProjectMaterialSerializer;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class ExperienceProjectMaterial
extends AbstractProjectMaterial {
    public static final String TYPE = "experience";
    public static final IProjectMaterialSerializer<ExperienceProjectMaterial> SERIALIZER = new Serializer();
    protected int levels;
    protected boolean consumed;

    public ExperienceProjectMaterial() {
        this(0, true);
    }

    public ExperienceProjectMaterial(int levels) {
        this(levels, true);
    }

    public ExperienceProjectMaterial(int levels, boolean consumed) {
        this.levels = levels;
        this.consumed = consumed;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("Levels", this.levels);
        tag.m_128379_("Consumed", this.consumed);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.levels = nbt.m_128451_("Levels");
        this.consumed = nbt.m_128471_("Consumed");
    }

    @Override
    protected String getMaterialType() {
        return TYPE;
    }

    @Override
    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        return player.f_36078_ >= this.levels;
    }

    @Override
    public boolean consume(Player player) {
        player.m_6749_(-1 * this.levels);
        return true;
    }

    public int getLevels() {
        return this.levels;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        SERIALIZER.toNetwork(buf, this);
    }

    @Override
    public AbstractProjectMaterial copy() {
        ExperienceProjectMaterial retVal = new ExperienceProjectMaterial();
        retVal.levels = this.levels;
        retVal.consumed = this.consumed;
        retVal.selected = this.selected;
        retVal.weight = this.weight;
        retVal.bonusReward = this.bonusReward;
        if (this.requiredResearch != null) {
            retVal.requiredResearch = this.requiredResearch.copy();
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.consumed ? 1231 : 1237);
        result = 31 * result + this.levels;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExperienceProjectMaterial other = (ExperienceProjectMaterial)obj;
        if (this.consumed != other.consumed) {
            return false;
        }
        return this.levels == other.levels;
    }

    public static class Serializer
    implements IProjectMaterialSerializer<ExperienceProjectMaterial> {
        @Override
        public ExperienceProjectMaterial read(ResourceLocation projectId, JsonObject json) {
            int levels = json.getAsJsonPrimitive("levels").getAsInt();
            if (levels <= 0) {
                throw new JsonSyntaxException("Invalid experience levels in material JSON for project " + projectId.toString());
            }
            boolean consumed = json.getAsJsonPrimitive("consumed").getAsBoolean();
            ExperienceProjectMaterial retVal = new ExperienceProjectMaterial(levels, consumed);
            retVal.setWeight(json.getAsJsonPrimitive("weight").getAsDouble());
            if (json.has("bonus_reward")) {
                retVal.setBonusReward(json.getAsJsonPrimitive("bonus_reward").getAsDouble());
            }
            if (json.has("required_research")) {
                retVal.setRequiredResearch(CompoundResearchKey.parse(json.getAsJsonPrimitive("required_research").getAsString()));
            }
            return retVal;
        }

        @Override
        public ExperienceProjectMaterial fromNetwork(FriendlyByteBuf buf) {
            ExperienceProjectMaterial material = new ExperienceProjectMaterial(buf.m_130242_(), buf.readBoolean());
            material.setWeight(buf.readDouble());
            material.setBonusReward(buf.readDouble());
            CompoundResearchKey research = CompoundResearchKey.parse(buf.m_130277_());
            if (research != null) {
                material.setRequiredResearch(research);
            }
            return material;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, ExperienceProjectMaterial material) {
            buf.m_130130_(material.levels);
            buf.writeBoolean(material.consumed);
            buf.writeDouble(material.weight);
            buf.writeDouble(material.bonusReward);
            buf.m_130070_(material.requiredResearch == null ? "" : material.requiredResearch.toString());
        }
    }
}

