/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.theorycrafting.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.IProjectMaterialSerializer;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemProjectMaterial
extends AbstractProjectMaterial {
    protected static final Logger LOGGER = LogManager.getLogger();
    public static final String TYPE = "item";
    public static final IProjectMaterialSerializer<ItemProjectMaterial> SERIALIZER = new Serializer();
    protected ItemStack stack;
    protected boolean consumed;
    protected boolean matchNBT;
    protected int afterCrafting;

    public ItemProjectMaterial() {
        this.stack = ItemStack.f_41583_;
        this.consumed = false;
        this.matchNBT = false;
        this.afterCrafting = 0;
    }

    public ItemProjectMaterial(@Nonnull ItemStack stack, boolean consumed, boolean matchNBT) {
        this.stack = stack;
        this.consumed = consumed;
        this.matchNBT = matchNBT;
        this.afterCrafting = 0;
    }

    public ItemProjectMaterial(@Nonnull ItemStack stack, boolean consumed) {
        this(stack, consumed, false);
    }

    public ItemProjectMaterial(@Nonnull ItemLike item, boolean consumed, boolean matchNBT) {
        this(new ItemStack(item), consumed, matchNBT);
    }

    public ItemProjectMaterial(@Nonnull ItemLike item, boolean consumed) {
        this(item, consumed, false);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("Stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        tag.m_128379_("Consumed", this.consumed);
        tag.m_128379_("MatchNBT", this.matchNBT);
        tag.m_128405_("AfterCrafting", this.afterCrafting);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Stack"));
        this.consumed = nbt.m_128471_("Consumed");
        this.matchNBT = nbt.m_128471_("MatchNBT");
        this.afterCrafting = nbt.m_128451_("AfterCrafting");
    }

    @Override
    protected String getMaterialType() {
        return TYPE;
    }

    @Override
    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        BlockItem blockItem;
        Item item;
        if (InventoryUtils.isPlayerCarrying(player, this.stack, this.matchNBT)) {
            return true;
        }
        return !this.consumed && this.stack.m_41613_() == 1 && surroundings != null && (item = this.stack.m_41720_()) instanceof BlockItem && surroundings.contains((blockItem = (BlockItem)item).m_40614_());
    }

    @Override
    public boolean consume(Player player) {
        if (this.consumed) {
            return InventoryUtils.consumeItem(player, this.stack, this.matchNBT);
        }
        return true;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    public int getAfterCrafting() {
        return this.afterCrafting;
    }

    public void setAfterCrafting(int after) {
        this.afterCrafting = after;
    }

    @Override
    public boolean isAllowedInProject(ServerPlayer player) {
        return super.isAllowedInProject(player) && player.m_8951_().m_13015_(Stats.f_12981_.m_12902_((Object)this.getItemStack().m_41720_())) >= this.getAfterCrafting();
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        SERIALIZER.toNetwork(buf, this);
    }

    @Override
    public AbstractProjectMaterial copy() {
        ItemProjectMaterial material = new ItemProjectMaterial();
        material.stack = this.stack.m_41777_();
        material.consumed = this.consumed;
        material.matchNBT = this.matchNBT;
        material.selected = this.selected;
        material.weight = this.weight;
        material.bonusReward = this.bonusReward;
        material.afterCrafting = this.afterCrafting;
        if (this.requiredResearch != null) {
            material.requiredResearch = this.requiredResearch.copy();
        }
        return material;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.afterCrafting, this.consumed, this.matchNBT, this.stack);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemProjectMaterial other = (ItemProjectMaterial)obj;
        return this.afterCrafting == other.afterCrafting && this.consumed == other.consumed && this.matchNBT == other.matchNBT && ItemStack.m_41728_((ItemStack)this.stack, (ItemStack)other.stack);
    }

    public static class Serializer
    implements IProjectMaterialSerializer<ItemProjectMaterial> {
        @Override
        public ItemProjectMaterial read(ResourceLocation projectId, JsonObject json) {
            ItemStack stack = ItemUtils.parseItemStack(json.getAsJsonPrimitive("stack").getAsString());
            if (stack == null || stack.m_41619_()) {
                throw new JsonSyntaxException("Invalid item stack for material in project " + projectId.toString());
            }
            boolean consumed = json.getAsJsonPrimitive("consumed").getAsBoolean();
            boolean matchNbt = json.has("match_nbt") ? json.getAsJsonPrimitive("match_nbt").getAsBoolean() : false;
            ItemProjectMaterial retVal = new ItemProjectMaterial(stack, consumed, matchNbt);
            retVal.setWeight(json.getAsJsonPrimitive("weight").getAsDouble());
            if (json.has("bonus_reward")) {
                retVal.setBonusReward(json.getAsJsonPrimitive("bonus_reward").getAsDouble());
            }
            if (json.has("after_crafting")) {
                retVal.setAfterCrafting(json.getAsJsonPrimitive("after_crafting").getAsInt());
            }
            if (json.has("required_research")) {
                retVal.setRequiredResearch(CompoundResearchKey.parse(json.getAsJsonPrimitive("required_research").getAsString()));
            }
            return retVal;
        }

        @Override
        public ItemProjectMaterial fromNetwork(FriendlyByteBuf buf) {
            ItemProjectMaterial material = new ItemProjectMaterial(buf.m_130267_(), buf.readBoolean(), buf.readBoolean());
            material.setWeight(buf.readDouble());
            material.setBonusReward(buf.readDouble());
            material.setAfterCrafting(buf.m_130242_());
            CompoundResearchKey research = CompoundResearchKey.parse(buf.m_130277_());
            if (research != null) {
                material.setRequiredResearch(research);
            }
            return material;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, ItemProjectMaterial material) {
            buf.writeItemStack(material.stack, false);
            buf.writeBoolean(material.consumed);
            buf.writeBoolean(material.matchNBT);
            buf.writeDouble(material.weight);
            buf.writeDouble(material.bonusReward);
            buf.m_130130_(material.afterCrafting);
            buf.m_130070_(material.requiredResearch == null ? "" : material.requiredResearch.toString());
        }
    }
}

