/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.theorycrafting.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.IProjectMaterialSerializer;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemTagProjectMaterial
extends AbstractProjectMaterial {
    public static final String TYPE = "tag";
    public static final IProjectMaterialSerializer<ItemTagProjectMaterial> SERIALIZER = new Serializer();
    protected ResourceLocation tagName;
    protected int quantity;
    protected boolean consumed;

    public ItemTagProjectMaterial() {
        this.tagName = null;
        this.quantity = -1;
        this.consumed = false;
    }

    public ItemTagProjectMaterial(@Nonnull ResourceLocation tagName, int quantity, boolean consumed) {
        this.tagName = tagName;
        this.quantity = quantity;
        this.consumed = consumed;
    }

    public ItemTagProjectMaterial(@Nonnull ResourceLocation tagName, boolean consumed) {
        this(tagName, 1, consumed);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        if (this.tagName != null) {
            tag.m_128359_("TagName", this.tagName.toString());
        }
        tag.m_128405_("Quantity", this.quantity);
        tag.m_128379_("Consumed", this.consumed);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.tagName = nbt.m_128441_("TagName") ? new ResourceLocation(nbt.m_128461_("TagName")) : null;
        this.quantity = nbt.m_128451_("Quantity");
        this.consumed = nbt.m_128471_("Consumed");
    }

    @Override
    protected String getMaterialType() {
        return TYPE;
    }

    @Override
    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        if (InventoryUtils.isPlayerCarrying(player, this.tagName, this.quantity)) {
            return true;
        }
        if (!this.consumed && this.quantity == 1 && surroundings != null) {
            TagKey blockTagKey = BlockTags.create((ResourceLocation)this.tagName);
            ArrayList tagContents = new ArrayList();
            ForgeRegistries.BLOCKS.tags().getTag(blockTagKey).forEach(b -> tagContents.add(b));
            HashSet<Block> intersection = new HashSet<Block>(surroundings);
            intersection.retainAll(tagContents);
            return !intersection.isEmpty();
        }
        return false;
    }

    @Override
    public boolean consume(Player player) {
        if (this.consumed) {
            return InventoryUtils.consumeItem(player, this.tagName, this.quantity);
        }
        return true;
    }

    @Nullable
    public ResourceLocation getTagName() {
        return this.tagName;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        SERIALIZER.toNetwork(buf, this);
    }

    @Override
    public AbstractProjectMaterial copy() {
        ItemTagProjectMaterial material = new ItemTagProjectMaterial();
        material.tagName = new ResourceLocation(this.tagName.toString());
        material.quantity = this.quantity;
        material.consumed = this.consumed;
        material.selected = this.selected;
        material.weight = this.weight;
        material.bonusReward = this.bonusReward;
        if (this.requiredResearch != null) {
            material.requiredResearch = this.requiredResearch.copy();
        }
        return material;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.consumed ? 1231 : 1237);
        result = 31 * result + this.quantity;
        result = 31 * result + (this.tagName == null ? 0 : this.tagName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ItemTagProjectMaterial other = (ItemTagProjectMaterial)obj;
        if (this.consumed != other.consumed) {
            return false;
        }
        if (this.quantity != other.quantity) {
            return false;
        }
        return !(this.tagName == null ? other.tagName != null : !this.tagName.equals((Object)other.tagName));
    }

    public static class Serializer
    implements IProjectMaterialSerializer<ItemTagProjectMaterial> {
        @Override
        public ItemTagProjectMaterial read(ResourceLocation projectId, JsonObject json) {
            String nameStr = json.getAsJsonPrimitive("name").getAsString();
            if (nameStr == null) {
                throw new JsonSyntaxException("Illegal tag name in material JSON for project " + projectId.toString());
            }
            ResourceLocation tagName = new ResourceLocation(nameStr);
            boolean consumed = json.getAsJsonPrimitive("consumed").getAsBoolean();
            int quantity = json.getAsJsonPrimitive("quantity").getAsInt();
            ItemTagProjectMaterial retVal = new ItemTagProjectMaterial(tagName, quantity, consumed);
            retVal.setWeight(json.getAsJsonPrimitive("weight").getAsDouble());
            if (json.has("bonus_reward")) {
                retVal.setBonusReward(json.getAsJsonPrimitive("bonus_reward").getAsDouble());
            }
            if (json.has("required_research")) {
                retVal.setRequiredResearch(CompoundResearchKey.parse(json.getAsJsonPrimitive("required_research").getAsString()));
            }
            return retVal;
        }

        @Override
        public ItemTagProjectMaterial fromNetwork(FriendlyByteBuf buf) {
            ItemTagProjectMaterial material = new ItemTagProjectMaterial(buf.m_130281_(), buf.m_130242_(), buf.readBoolean());
            material.setWeight(buf.readDouble());
            material.setBonusReward(buf.readDouble());
            CompoundResearchKey research = CompoundResearchKey.parse(buf.m_130277_());
            if (research != null) {
                material.setRequiredResearch(research);
            }
            return material;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, ItemTagProjectMaterial material) {
            buf.m_130085_(material.tagName);
            buf.m_130130_(material.quantity);
            buf.writeBoolean(material.consumed);
            buf.writeDouble(material.weight);
            buf.writeDouble(material.bonusReward);
            buf.m_130070_(material.requiredResearch == null ? "" : material.requiredResearch.toString());
        }
    }
}

