/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.theorycrafting.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.IProjectMaterialSerializer;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class ObservationProjectMaterial
extends AbstractProjectMaterial {
    public static final String TYPE = "observation";
    public static final IProjectMaterialSerializer<ObservationProjectMaterial> SERIALIZER = new Serializer();
    protected int count;
    protected boolean consumed;

    public ObservationProjectMaterial() {
        this(0, true);
    }

    public ObservationProjectMaterial(int count) {
        this(count, true);
    }

    public ObservationProjectMaterial(int count, boolean consumed) {
        this.count = count;
        this.consumed = consumed;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("Count", this.count);
        tag.m_128379_("Consumed", this.consumed);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.count = nbt.m_128451_("Count");
        this.consumed = nbt.m_128471_("Consumed");
    }

    @Override
    protected String getMaterialType() {
        return TYPE;
    }

    @Override
    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        IPlayerKnowledge knowledge = (IPlayerKnowledge)PrimalMagickCapabilities.getKnowledge(player).orElse(null);
        return knowledge != null && knowledge.getKnowledge(KnowledgeType.OBSERVATION) >= this.count;
    }

    @Override
    public boolean consume(Player player) {
        return ResearchManager.addKnowledge(player, KnowledgeType.OBSERVATION, -1 * this.count * KnowledgeType.OBSERVATION.getProgression());
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        SERIALIZER.toNetwork(buf, this);
    }

    @Override
    public AbstractProjectMaterial copy() {
        ObservationProjectMaterial material = new ObservationProjectMaterial();
        material.count = this.count;
        material.consumed = this.consumed;
        material.selected = this.selected;
        material.weight = this.weight;
        material.bonusReward = this.bonusReward;
        if (this.requiredResearch != null) {
            material.requiredResearch = this.requiredResearch.copy();
        }
        return material;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.consumed ? 1231 : 1237);
        result = 31 * result + this.count;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObservationProjectMaterial other = (ObservationProjectMaterial)obj;
        if (this.consumed != other.consumed) {
            return false;
        }
        return this.count == other.count;
    }

    public static class Serializer
    implements IProjectMaterialSerializer<ObservationProjectMaterial> {
        @Override
        public ObservationProjectMaterial read(ResourceLocation projectId, JsonObject json) {
            int count = json.getAsJsonPrimitive("count").getAsInt();
            if (count <= 0) {
                throw new JsonSyntaxException("Invalid observation count in material JSON for project " + projectId.toString());
            }
            boolean consumed = json.getAsJsonPrimitive("consumed").getAsBoolean();
            ObservationProjectMaterial retVal = new ObservationProjectMaterial(count, consumed);
            retVal.setWeight(json.getAsJsonPrimitive("weight").getAsDouble());
            if (json.has("bonus_reward")) {
                retVal.setBonusReward(json.getAsJsonPrimitive("bonus_reward").getAsDouble());
            }
            if (json.has("required_research")) {
                retVal.setRequiredResearch(CompoundResearchKey.parse(json.getAsJsonPrimitive("required_research").getAsString()));
            }
            return retVal;
        }

        @Override
        public ObservationProjectMaterial fromNetwork(FriendlyByteBuf buf) {
            ObservationProjectMaterial material = new ObservationProjectMaterial(buf.m_130242_(), buf.readBoolean());
            material.setWeight(buf.readDouble());
            material.setBonusReward(buf.readDouble());
            CompoundResearchKey research = CompoundResearchKey.parse(buf.m_130277_());
            if (research != null) {
                material.setRequiredResearch(research);
            }
            return material;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, ObservationProjectMaterial material) {
            buf.m_130130_(material.count);
            buf.writeBoolean(material.consumed);
            buf.writeDouble(material.weight);
            buf.writeDouble(material.bonusReward);
            buf.m_130070_(material.requiredResearch == null ? "" : material.requiredResearch.toString());
        }
    }
}

