/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.verdantartifice.primalmagick.common.config.Config;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.theorycrafting.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.ProjectFactory;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftSpeed;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;

public class Project
implements INBTSerializable<CompoundTag> {
    protected ResourceLocation templateKey;
    protected List<AbstractProjectMaterial> activeMaterials = new ArrayList<AbstractProjectMaterial>();
    protected List<AbstractReward> otherRewards = new ArrayList<AbstractReward>();
    protected double baseSuccessChance;
    protected double baseRewardMultiplier;
    protected ResourceLocation aidBlock;

    public Project() {
    }

    public Project(@Nonnull ResourceLocation templateKey, @Nonnull List<AbstractProjectMaterial> materials, @Nonnull List<AbstractReward> otherRewards, double baseSuccessChance, double baseRewardMultiplier, @Nullable ResourceLocation aidBlock) {
        this.templateKey = templateKey;
        this.activeMaterials = materials;
        this.otherRewards = otherRewards;
        this.baseSuccessChance = baseSuccessChance;
        this.baseRewardMultiplier = baseRewardMultiplier;
        this.aidBlock = aidBlock;
    }

    public CompoundTag serializeNBT() {
        CompoundTag retVal = new CompoundTag();
        retVal.m_128359_("TemplateKey", this.templateKey.toString());
        retVal.m_128347_("BaseSuccessChance", this.baseSuccessChance);
        retVal.m_128347_("BaseRewardMultiplier", this.baseRewardMultiplier);
        if (this.aidBlock != null) {
            retVal.m_128359_("AidBlock", this.aidBlock.toString());
        }
        ListTag materialList = new ListTag();
        for (AbstractProjectMaterial material : this.activeMaterials) {
            materialList.add((Object)material.serializeNBT());
        }
        retVal.m_128365_("Materials", (Tag)materialList);
        ListTag rewardList = new ListTag();
        for (AbstractReward reward : this.otherRewards) {
            rewardList.add((Object)reward.serializeNBT());
        }
        retVal.m_128365_("OtherRewards", (Tag)rewardList);
        return retVal;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.templateKey = new ResourceLocation(nbt.m_128461_("TemplateKey"));
        this.baseSuccessChance = nbt.m_128459_("BaseSuccessChance");
        this.baseRewardMultiplier = nbt.m_128459_("BaseRewardMultiplier");
        this.aidBlock = null;
        if (nbt.m_128441_("AidBlock")) {
            this.aidBlock = new ResourceLocation(nbt.m_128461_("AidBlock"));
        }
        this.activeMaterials.clear();
        ListTag materialList = nbt.m_128437_("Materials", 10);
        for (int index = 0; index < materialList.size(); ++index) {
            AbstractProjectMaterial material = ProjectFactory.getMaterialFromNBT(materialList.m_128728_(index));
            if (material == null) continue;
            this.activeMaterials.add(material);
        }
        this.otherRewards.clear();
        ListTag rewardList = nbt.m_128437_("OtherRewards", 10);
        for (int index = 0; index < rewardList.size(); ++index) {
            AbstractReward reward = ProjectFactory.getRewardFromNBT(rewardList.m_128728_(index));
            if (reward == null) continue;
            this.otherRewards.add(reward);
        }
    }

    @Nonnull
    public String getNameTranslationKey() {
        return String.join((CharSequence)".", "research_project", this.templateKey.m_135827_(), this.templateKey.m_135815_(), "name");
    }

    @Nonnull
    public String getTextTranslationKey() {
        return String.join((CharSequence)".", "research_project", this.templateKey.m_135827_(), this.templateKey.m_135815_(), "text");
    }

    @Nonnull
    public List<AbstractProjectMaterial> getMaterials() {
        return this.activeMaterials;
    }

    @Nonnull
    public List<AbstractReward> getOtherRewards() {
        return this.otherRewards;
    }

    protected double getSuccessChancePerMaterial() {
        int materialCount = this.activeMaterials.size();
        if (materialCount <= 0) {
            return 0.0;
        }
        return (1.0 - this.baseSuccessChance) / (double)materialCount;
    }

    public double getSuccessChance() {
        double chance = this.baseSuccessChance;
        double per = this.getSuccessChancePerMaterial();
        for (AbstractProjectMaterial material : this.getMaterials()) {
            if (!material.isSelected()) continue;
            chance += per;
        }
        return Mth.m_14008_((double)chance, (double)0.0, (double)1.0);
    }

    public boolean isSatisfied(Player player, Set<Block> surroundings) {
        for (AbstractProjectMaterial material : this.getMaterials()) {
            if (!material.isSelected() || material.isSatisfied(player, surroundings)) continue;
            return false;
        }
        return true;
    }

    public boolean consumeSelectedMaterials(Player player) {
        for (AbstractProjectMaterial material : this.getMaterials()) {
            if (!material.isSelected() || material.consume(player)) continue;
            return false;
        }
        return true;
    }

    public int getTheoryPointReward() {
        int value = (int)((double)KnowledgeType.THEORY.getProgression() * (this.baseRewardMultiplier + this.getMaterials().stream().filter(m -> m.isSelected()).mapToDouble(m -> m.getBonusReward()).sum()));
        TheorycraftSpeed modifier = (TheorycraftSpeed)((Object)Config.THEORYCRAFT_SPEED.get());
        if (modifier == TheorycraftSpeed.SLOW) {
            value /= 2;
        } else if (modifier == TheorycraftSpeed.FAST) {
            value *= 2;
        }
        return value;
    }

    @Nullable
    public Block getAidBlock() {
        return this.aidBlock == null ? null : (Block)ForgeRegistries.BLOCKS.getValue(this.aidBlock);
    }
}

