/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.verdantartifice.primalmagick.common.research.IResearchKey;
import com.verdantartifice.primalmagick.common.research.ResearchKeyFactory;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.theorycrafting.AbstractProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.IProjectMaterialSerializer;
import com.verdantartifice.primalmagick.common.theorycrafting.IProjectTemplateSerializer;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.theorycrafting.TheorycraftManager;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.IRewardSerializer;
import com.verdantartifice.primalmagick.common.theorycrafting.weights.IWeightFunction;
import com.verdantartifice.primalmagick.common.theorycrafting.weights.IWeightFunctionSerializer;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProjectTemplate {
    protected ResourceLocation key;
    protected List<AbstractProjectMaterial> materialOptions = new ArrayList<AbstractProjectMaterial>();
    protected List<AbstractReward> otherRewards = new ArrayList<AbstractReward>();
    protected IResearchKey requiredResearch;
    protected Optional<Integer> requiredMaterialCountOverride = Optional.empty();
    protected Optional<Double> baseSuccessChanceOverride = Optional.empty();
    protected double rewardMultiplier = 0.25;
    protected List<ResourceLocation> aidBlocks = new ArrayList<ResourceLocation>();
    protected Optional<IWeightFunction> weightFunction = Optional.empty();

    protected ProjectTemplate(@Nonnull ResourceLocation key, @Nonnull List<AbstractProjectMaterial> materialOptions, @Nonnull List<AbstractReward> otherRewards, @Nullable IResearchKey requiredResearch, @Nonnull Optional<Integer> requiredMaterialCountOverride, @Nonnull Optional<Double> baseSuccessChanceOverride, double rewardMultiplier, @Nonnull List<ResourceLocation> aidBlocks, @Nonnull Optional<IWeightFunction> weightFunction) {
        this.key = key;
        this.materialOptions = materialOptions;
        this.otherRewards = otherRewards;
        this.requiredResearch = requiredResearch;
        this.requiredMaterialCountOverride = requiredMaterialCountOverride;
        this.baseSuccessChanceOverride = baseSuccessChanceOverride;
        this.rewardMultiplier = rewardMultiplier;
        this.aidBlocks = aidBlocks;
        this.weightFunction = weightFunction;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    @Nullable
    public List<ResourceLocation> getAidBlocks() {
        return this.aidBlocks;
    }

    public double getWeight(Player player) {
        if (this.weightFunction.isPresent()) {
            return this.weightFunction.get().getWeight(player);
        }
        return 1.0;
    }

    @Nullable
    public Project initialize(ServerPlayer player, Set<Block> nearby) {
        if (this.requiredResearch != null && !this.requiredResearch.isKnownByStrict((Player)player)) {
            return null;
        }
        ResourceLocation foundAid = null;
        if (!this.aidBlocks.isEmpty()) {
            boolean found = false;
            Set nearbyIds = nearby.stream().map(b -> ForgeRegistries.BLOCKS.getKey(b)).collect(Collectors.toUnmodifiableSet());
            for (ResourceLocation aidBlock : this.aidBlocks) {
                if (!nearbyIds.contains(aidBlock)) continue;
                found = true;
                foundAid = aidBlock;
                break;
            }
            if (!found) {
                return null;
            }
        }
        int maxMaterials = this.getRequiredMaterialCount((Player)player);
        ArrayList<AbstractProjectMaterial> materials = new ArrayList<AbstractProjectMaterial>();
        WeightedRandomBag<AbstractProjectMaterial> options = this.getMaterialOptions(player);
        for (int attempts = 0; materials.size() < maxMaterials && attempts < 1000; ++attempts) {
            AbstractProjectMaterial material = options.getRandom(player.m_217043_()).copy();
            if (materials.contains(material)) continue;
            materials.add(material);
        }
        if (materials.size() < maxMaterials) {
            return null;
        }
        return new Project(this.key, materials, this.otherRewards, this.getBaseSuccessChance((Player)player), this.rewardMultiplier, foundAid);
    }

    protected int getRequiredMaterialCount(Player player) {
        return this.requiredMaterialCountOverride.orElseGet(() -> {
            int completed = StatsManager.getValue(player, StatsPM.RESEARCH_PROJECTS_COMPLETED);
            return Math.min(4, 1 + completed / 5);
        });
    }

    protected double getBaseSuccessChance(Player player) {
        return this.baseSuccessChanceOverride.orElseGet(() -> {
            int completed = StatsManager.getValue(player, StatsPM.RESEARCH_PROJECTS_COMPLETED);
            return Math.max(0.0, 0.5 - 0.1 * (double)(completed / 3));
        });
    }

    @Nonnull
    protected WeightedRandomBag<AbstractProjectMaterial> getMaterialOptions(ServerPlayer player) {
        WeightedRandomBag<AbstractProjectMaterial> retVal = new WeightedRandomBag<AbstractProjectMaterial>();
        for (AbstractProjectMaterial material : this.materialOptions) {
            if (!material.isAllowedInProject(player)) continue;
            retVal.add(material, material.getWeight());
        }
        return retVal;
    }

    public static class Serializer
    implements IProjectTemplateSerializer {
        private static final Logger LOGGER = LogManager.getLogger();

        @Override
        public ProjectTemplate read(ResourceLocation templateId, JsonObject json) {
            String keyStr = json.getAsJsonPrimitive("key").getAsString();
            if (keyStr == null) {
                throw new JsonSyntaxException("Illegal key in project template JSON for " + templateId.toString());
            }
            ResourceLocation key = new ResourceLocation(keyStr);
            IResearchKey requiredResearch = null;
            if (json.has("required_research")) {
                requiredResearch = ResearchKeyFactory.parse(json.getAsJsonPrimitive("required_research").getAsString());
            }
            Optional<Integer> materialCountOverride = Optional.empty();
            if (json.has("required_material_count_override")) {
                materialCountOverride = Optional.of(json.getAsJsonPrimitive("required_material_count_override").getAsInt());
            }
            Optional<Double> baseSuccessChanceOverride = Optional.empty();
            if (json.has("base_success_chance_override")) {
                baseSuccessChanceOverride = Optional.of(json.getAsJsonPrimitive("base_success_chance_override").getAsDouble());
            }
            double rewardMultiplier = json.getAsJsonPrimitive("reward_multiplier").getAsDouble();
            ArrayList<ResourceLocation> aidBlocks = new ArrayList<ResourceLocation>();
            JsonArray aidsArray = json.getAsJsonArray("aid_blocks");
            for (JsonElement aidElement : aidsArray) {
                ResourceLocation aidBlock;
                try {
                    aidBlock = new ResourceLocation(aidElement.getAsString());
                }
                catch (Exception e) {
                    throw new JsonSyntaxException("Invalid aid block in project template JSON for " + templateId.toString());
                }
                if (!ForgeRegistries.BLOCKS.containsKey(aidBlock)) {
                    throw new JsonSyntaxException("Invalid aid block in project template JSON for " + templateId.toString());
                }
                aidBlocks.add(aidBlock);
            }
            ArrayList<AbstractProjectMaterial> materials = new ArrayList<AbstractProjectMaterial>();
            JsonArray materialsArray = json.getAsJsonArray("material_options");
            for (JsonElement materialElement : materialsArray) {
                try {
                    JsonObject materialObj = materialElement.getAsJsonObject();
                    IProjectMaterialSerializer<?> materialSerializer = TheorycraftManager.getMaterialSerializer(materialObj.getAsJsonPrimitive("type").getAsString());
                    materials.add((AbstractProjectMaterial)materialSerializer.read(templateId, materialObj));
                }
                catch (Exception e) {
                    throw new JsonSyntaxException("Invalid material in project template JSON for " + templateId.toString(), (Throwable)e);
                }
            }
            ArrayList<AbstractReward> otherRewards = new ArrayList<AbstractReward>();
            if (json.has("other_rewards")) {
                JsonArray rewardsArray = json.getAsJsonArray("other_rewards");
                for (JsonElement rewardElement : rewardsArray) {
                    try {
                        JsonObject rewardObj = rewardElement.getAsJsonObject();
                        IRewardSerializer<?> rewardSerializer = TheorycraftManager.getRewardSerializer(rewardObj.getAsJsonPrimitive("type").getAsString());
                        otherRewards.add((AbstractReward)rewardSerializer.read(templateId, rewardObj));
                    }
                    catch (Exception e) {
                        throw new JsonSyntaxException("Invalid reward in project template JSON for " + templateId.toString(), (Throwable)e);
                    }
                }
            }
            Optional<IWeightFunction> weightOpt = Optional.empty();
            if (json.has("weight_function")) {
                JsonObject weightObj = json.getAsJsonObject("weight_function");
                String functionType = weightObj.getAsJsonPrimitive("type").getAsString();
                IWeightFunctionSerializer<?> serializer = TheorycraftManager.getWeightFunctionSerializer(functionType);
                if (serializer != null) {
                    weightOpt = Optional.ofNullable(serializer.read(templateId, weightObj));
                } else {
                    LOGGER.warn("Unknown weight function type {} in JSON for project template {}", (Object)functionType, (Object)templateId.toString());
                    weightOpt = Optional.empty();
                }
            }
            return new ProjectTemplate(key, materials, otherRewards, requiredResearch, materialCountOverride, baseSuccessChanceOverride, rewardMultiplier, aidBlocks, weightOpt);
        }

        @Override
        public ProjectTemplate fromNetwork(FriendlyByteBuf buf) {
            Optional<IWeightFunction> weightOpt;
            Object serializer;
            ResourceLocation key = buf.m_130281_();
            IResearchKey requiredResearch = buf.readBoolean() ? ResearchKeyFactory.parse(buf.m_130277_()) : null;
            Optional<Integer> materialCountOverride = buf.readBoolean() ? Optional.of(buf.m_130242_()) : Optional.empty();
            Optional<Double> baseSuccessChanceOverride = buf.readBoolean() ? Optional.of(buf.readDouble()) : Optional.empty();
            double rewardMultiplier = buf.readDouble();
            ArrayList<ResourceLocation> aidBlocks = new ArrayList<ResourceLocation>();
            int aidCount = buf.m_130242_();
            for (int index = 0; index < aidCount; ++index) {
                aidBlocks.add(buf.m_130281_());
            }
            ArrayList<AbstractProjectMaterial> materials = new ArrayList<AbstractProjectMaterial>();
            int materialCount = buf.m_130242_();
            for (int index = 0; index < materialCount; ++index) {
                String materialType = buf.m_130277_();
                IProjectMaterialSerializer<?> serializer2 = TheorycraftManager.getMaterialSerializer(materialType);
                if (serializer2 == null) {
                    throw new IllegalArgumentException("Unknown theorycrafting project material type " + materialType);
                }
                materials.add((AbstractProjectMaterial)serializer2.fromNetwork(buf));
            }
            ArrayList<AbstractReward> rewards = new ArrayList<AbstractReward>();
            int rewardCount = buf.m_130242_();
            for (int index = 0; index < rewardCount; ++index) {
                String rewardType = buf.m_130277_();
                serializer = TheorycraftManager.getRewardSerializer(rewardType);
                if (serializer == null) {
                    throw new IllegalArgumentException("Unknown theorycrafting project reward type " + rewardType);
                }
                rewards.add((AbstractReward)serializer.fromNetwork(buf));
            }
            if (buf.readBoolean()) {
                String functionType = buf.m_130277_();
                serializer = TheorycraftManager.getWeightFunctionSerializer(functionType);
                if (serializer != null) {
                    weightOpt = Optional.ofNullable(serializer.fromNetwork(buf));
                } else {
                    LOGGER.warn("Unknown weight function type {} from network for project template {}", (Object)functionType, (Object)key.toString());
                    weightOpt = Optional.empty();
                }
            } else {
                weightOpt = Optional.empty();
            }
            return new ProjectTemplate(key, materials, rewards, requiredResearch, materialCountOverride, baseSuccessChanceOverride, rewardMultiplier, aidBlocks, weightOpt);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, ProjectTemplate template) {
            buf.m_130085_(template.key);
            if (template.requiredResearch != null) {
                buf.writeBoolean(true);
                buf.m_130070_(template.requiredResearch.toString());
            } else {
                buf.writeBoolean(false);
            }
            template.requiredMaterialCountOverride.ifPresentOrElse(val -> {
                buf.writeBoolean(true);
                buf.m_130130_(val.intValue());
            }, () -> buf.writeBoolean(false));
            template.baseSuccessChanceOverride.ifPresentOrElse(val -> {
                buf.writeBoolean(true);
                buf.writeDouble(val.doubleValue());
            }, () -> buf.writeBoolean(false));
            buf.writeDouble(template.rewardMultiplier);
            buf.m_130130_(template.aidBlocks.size());
            for (ResourceLocation aidBlock : template.aidBlocks) {
                buf.m_130085_(aidBlock);
            }
            buf.m_130130_(template.materialOptions.size());
            for (AbstractProjectMaterial material : template.materialOptions) {
                buf.m_130070_(material.getMaterialType());
                material.toNetwork(buf);
            }
            buf.m_130130_(template.otherRewards.size());
            for (AbstractReward reward : template.otherRewards) {
                buf.m_130070_(reward.getRewardType());
                reward.getSerializer().toNetwork(buf, reward);
            }
            template.weightFunction.ifPresentOrElse(weight -> {
                buf.writeBoolean(true);
                buf.m_130070_(weight.getFunctionType());
                weight.getSerializer().toNetwork(buf, (IWeightFunction)weight);
            }, () -> buf.writeBoolean(false));
        }
    }
}

