/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.theorycrafting.ExperienceProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.IProjectMaterialSerializer;
import com.verdantartifice.primalmagick.common.theorycrafting.IProjectTemplateSerializer;
import com.verdantartifice.primalmagick.common.theorycrafting.ItemProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.ItemTagProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.ObservationProjectMaterial;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.theorycrafting.ProjectTemplate;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.ExperienceReward;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.IRewardSerializer;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.ItemReward;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.LootTableReward;
import com.verdantartifice.primalmagick.common.theorycrafting.weights.ConstantWeight;
import com.verdantartifice.primalmagick.common.theorycrafting.weights.IWeightFunctionSerializer;
import com.verdantartifice.primalmagick.common.theorycrafting.weights.ProgressiveWeight;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class TheorycraftManager {
    public static final IProjectTemplateSerializer TEMPLATE_SERIALIZER = new ProjectTemplate.Serializer();
    protected static final Map<String, IProjectMaterialSerializer<?>> MATERIAL_SERIALIZERS = new ImmutableMap.Builder().put((Object)"item", ItemProjectMaterial.SERIALIZER).put((Object)"tag", ItemTagProjectMaterial.SERIALIZER).put((Object)"experience", ExperienceProjectMaterial.SERIALIZER).put((Object)"observation", ObservationProjectMaterial.SERIALIZER).build();
    protected static final Map<String, IRewardSerializer<?>> REWARD_SERIALIZERS = new ImmutableMap.Builder().put((Object)"experience", ExperienceReward.SERIALIZER).put((Object)"item", ItemReward.SERIALIZER).put((Object)"loot_table", LootTableReward.SERIALIZER).build();
    protected static final Map<String, IWeightFunctionSerializer<?>> WEIGHT_SERIALIZERS = new ImmutableMap.Builder().put((Object)"constant", ConstantWeight.SERIALIZER).put((Object)"progressive", ProgressiveWeight.SERIALIZER).build();
    protected static final Map<ResourceLocation, ProjectTemplate> TEMPLATES = new HashMap<ResourceLocation, ProjectTemplate>();

    @Nullable
    public static IProjectMaterialSerializer<?> getMaterialSerializer(@Nullable String type) {
        return MATERIAL_SERIALIZERS.get(type);
    }

    @Nullable
    public static IRewardSerializer<?> getRewardSerializer(@Nullable String type) {
        return REWARD_SERIALIZERS.get(type);
    }

    @Nullable
    public static IWeightFunctionSerializer<?> getWeightFunctionSerializer(@Nullable String type) {
        return WEIGHT_SERIALIZERS.get(type);
    }

    public static void clearAllTemplates() {
        TEMPLATES.clear();
    }

    public static Map<ResourceLocation, ProjectTemplate> getAllTemplates() {
        return Collections.unmodifiableMap(TEMPLATES);
    }

    public static boolean registerTemplate(ResourceLocation templateKey, ProjectTemplate template) {
        if (TEMPLATES.containsKey(templateKey)) {
            return false;
        }
        TEMPLATES.put(templateKey, template);
        return true;
    }

    @Nonnull
    public static Project createRandomProject(@Nonnull ServerPlayer player, @Nonnull BlockPos tablePos) {
        WeightedRandomBag<ProjectTemplate> templateBag = new WeightedRandomBag<ProjectTemplate>();
        for (ProjectTemplate template : TEMPLATES.values()) {
            templateBag.add(template, template.getWeight((Player)player));
        }
        HashSet<Block> nearby = new HashSet<Block>();
        Level level = player.m_9236_();
        if (level.isAreaLoaded(tablePos, 5)) {
            Iterable positions = BlockPos.m_121940_((BlockPos)tablePos.m_7918_(-5, -5, -5), (BlockPos)tablePos.m_7918_(5, 5, 5));
            for (BlockPos pos : positions) {
                nearby.add(level.m_8055_(pos).m_60734_());
            }
        }
        Project retVal = null;
        for (int attempts = 0; retVal == null && attempts < 1000; ++attempts) {
            ProjectTemplate selectedTemplate = (ProjectTemplate)templateBag.getRandom(player.m_217043_());
            Project initializedProject = selectedTemplate.initialize(player, nearby);
            if (initializedProject == null) continue;
            retVal = initializedProject;
        }
        return retVal;
    }

    @Nonnull
    protected static Set<ResourceLocation> getAllAidBlockIds() {
        return TEMPLATES.values().stream().flatMap(t -> t.getAidBlocks().stream()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Nonnull
    public static Set<Block> getNearbyAidBlocks(Level level, BlockPos pos) {
        Set<ResourceLocation> allAids = TheorycraftManager.getAllAidBlockIds();
        return TheorycraftManager.getSurroundingsInner(level, pos, b -> allAids.contains(ForgeRegistries.BLOCKS.getKey(b)));
    }

    @Nonnull
    public static Set<Block> getSurroundings(Level level, BlockPos pos) {
        return TheorycraftManager.getSurroundingsInner(level, pos, b -> true);
    }

    @Nonnull
    protected static Set<Block> getSurroundingsInner(Level level, BlockPos pos, Predicate<Block> filter) {
        HashSet<Block> retVal = new HashSet<Block>();
        if (level.isAreaLoaded(pos, 5)) {
            Iterable positions = BlockPos.m_121940_((BlockPos)pos.m_7918_(-5, -5, -5), (BlockPos)pos.m_7918_(5, 5, 5));
            for (BlockPos searchPos : positions) {
                Block block = level.m_8055_(searchPos).m_60734_();
                if (!filter.test(block)) continue;
                retVal.add(block);
            }
        }
        return retVal;
    }
}

