/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.rewards;

import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.IRewardSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ExperienceReward
extends AbstractReward {
    public static final String TYPE = "experience";
    public static final IRewardSerializer<ExperienceReward> SERIALIZER = new Serializer();
    private int points;

    public ExperienceReward() {
        this.points = 0;
    }

    protected ExperienceReward(int points) {
        this.points = points;
    }

    @Override
    public void grant(ServerPlayer player) {
        player.m_6756_(this.points);
    }

    @Override
    public Component getDescription() {
        MutableComponent label = Component.m_237115_((String)"label.primalmagick.experience.points");
        return Component.m_237110_((String)"label.primalmagick.research_table.reward", (Object[])new Object[]{this.points, label});
    }

    @Override
    public String getRewardType() {
        return TYPE;
    }

    public IRewardSerializer<ExperienceReward> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("Points", this.points);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.points = nbt.m_128451_("Points");
    }

    public static class Serializer
    implements IRewardSerializer<ExperienceReward> {
        @Override
        public ExperienceReward read(ResourceLocation templateId, JsonObject json) {
            int points = json.getAsJsonPrimitive("points").getAsInt();
            return new ExperienceReward(points);
        }

        @Override
        public ExperienceReward fromNetwork(FriendlyByteBuf buf) {
            return new ExperienceReward(buf.m_130242_());
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, ExperienceReward reward) {
            buf.m_130130_(reward.points);
        }
    }
}

