/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.rewards;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.IRewardSerializer;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class ItemReward
extends AbstractReward {
    public static final String TYPE = "item";
    public static final IRewardSerializer<ItemReward> SERIALIZER = new Serializer();
    private ItemStack stack;

    public ItemReward() {
        this.stack = ItemStack.f_41583_;
    }

    protected ItemReward(@Nonnull ItemStack stack) {
        this.stack = stack.m_41777_();
    }

    @Override
    public void grant(ServerPlayer player) {
        if (!player.m_36356_(this.stack)) {
            ItemEntity entity = player.m_36176_(this.stack, false);
            if (entity != null) {
                entity.m_32061_();
                entity.m_266426_(player.m_20148_());
            }
        } else {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    @Override
    public Component getDescription() {
        MutableComponent itemName = Component.m_237119_().m_7220_(this.stack.m_41786_()).m_130938_(this.stack.m_41791_().getStyleModifier());
        if (this.stack.m_41788_()) {
            itemName.m_130940_(ChatFormatting.ITALIC);
        }
        return Component.m_237110_((String)"label.primalmagick.research_table.reward", (Object[])new Object[]{this.stack.m_41613_(), itemName});
    }

    @Override
    public String getRewardType() {
        return TYPE;
    }

    public IRewardSerializer<ItemReward> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("Stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Stack"));
    }

    public static class Serializer
    implements IRewardSerializer<ItemReward> {
        @Override
        public ItemReward read(ResourceLocation templateId, JsonObject json) {
            ItemStack stack = ItemUtils.parseItemStack(json.getAsJsonPrimitive("stack").getAsString());
            if (stack == null || stack.m_41619_()) {
                throw new JsonSyntaxException("Invalid item stack for reward in project " + templateId.toString());
            }
            return new ItemReward(stack);
        }

        @Override
        public ItemReward fromNetwork(FriendlyByteBuf buf) {
            return new ItemReward(buf.m_130267_());
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, ItemReward reward) {
            buf.writeItemStack(reward.stack, false);
        }
    }
}

