/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.theorycrafting.rewards;

import com.google.gson.JsonObject;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.AbstractReward;
import com.verdantartifice.primalmagick.common.theorycrafting.rewards.IRewardSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LootTableReward
extends AbstractReward {
    public static final String TYPE = "loot_table";
    public static final IRewardSerializer<LootTableReward> SERIALIZER = new Serializer();
    private ResourceLocation lootTable;
    private int pullCount;
    private String descTranslationKey;

    public LootTableReward() {
        this.lootTable = null;
        this.pullCount = 0;
        this.descTranslationKey = "";
    }

    protected LootTableReward(ResourceLocation lootTable, int pullCount, String descTranslationKey) {
        this.lootTable = lootTable;
        this.pullCount = pullCount;
        this.descTranslationKey = descTranslationKey;
    }

    @Override
    public void grant(ServerPlayer player) {
        LootParams params = new LootParams.Builder(player.m_284548_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287239_(player.m_36336_()).m_287235_(LootContextParamSets.f_81418_);
        boolean playSound = false;
        for (int index = 0; index < this.pullCount; ++index) {
            for (ItemStack stack : player.m_20194_().m_278653_().m_278676_(this.lootTable).m_287195_(params)) {
                if (!player.m_36356_(stack)) {
                    ItemEntity entity = player.m_36176_(stack, false);
                    if (entity == null) continue;
                    entity.m_32061_();
                    entity.m_266426_(player.m_20148_());
                    continue;
                }
                playSound = true;
            }
        }
        if (playSound) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    @Override
    public Component getDescription() {
        return Component.m_237110_((String)"label.primalmagick.research_table.reward", (Object[])new Object[]{this.pullCount, Component.m_237115_((String)this.descTranslationKey)});
    }

    @Override
    public String getRewardType() {
        return TYPE;
    }

    public IRewardSerializer<LootTableReward> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128359_("LootTable", this.lootTable.toString());
        tag.m_128405_("PullCount", this.pullCount);
        tag.m_128359_("DescTranslationKey", this.descTranslationKey);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.lootTable = new ResourceLocation(nbt.m_128461_("LootTable"));
        this.pullCount = nbt.m_128451_("PullCount");
        this.descTranslationKey = nbt.m_128461_("DescTranslationKey");
    }

    public static class Serializer
    implements IRewardSerializer<LootTableReward> {
        @Override
        public LootTableReward read(ResourceLocation templateId, JsonObject json) {
            ResourceLocation lootTable = new ResourceLocation(json.getAsJsonPrimitive("table").getAsString());
            int pullCount = json.getAsJsonPrimitive("pulls").getAsInt();
            String descTranslationKey = json.getAsJsonPrimitive("desc").getAsString();
            return new LootTableReward(lootTable, pullCount, descTranslationKey);
        }

        @Override
        public LootTableReward fromNetwork(FriendlyByteBuf buf) {
            return new LootTableReward(buf.m_130281_(), buf.m_130242_(), buf.m_130277_());
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, LootTableReward reward) {
            buf.m_130085_(reward.lootTable);
            buf.m_130130_(reward.pullCount);
            buf.m_130070_(reward.descTranslationKey);
        }
    }
}

