/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.base;

import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public abstract class AbstractTileInventoryPM
extends AbstractTilePM {
    protected NonNullList<ItemStack> items;
    protected NonNullList<ItemStack> syncedItems;
    protected List<ContainerListener> listeners;
    protected final Set<Integer> syncedSlotIndices;
    protected final int inventorySize;
    protected ItemStackHandlerPM itemHandler;
    protected final LazyOptional<IItemHandler> itemHandlerOpt = LazyOptional.of(() -> this.itemHandler);

    public AbstractTileInventoryPM(BlockEntityType<?> type, BlockPos pos, BlockState state, int invSize) {
        super(type, pos, state);
        this.items = NonNullList.m_122780_((int)invSize, (Object)ItemStack.f_41583_);
        this.syncedItems = NonNullList.m_122780_((int)invSize, (Object)ItemStack.f_41583_);
        this.syncedSlotIndices = this.getSyncedSlotIndices();
        this.itemHandler = this.createHandler();
        this.inventorySize = invSize;
    }

    protected Set<Integer> getSyncedSlotIndices() {
        return Collections.emptySet();
    }

    public int getInventorySize() {
        return this.inventorySize;
    }

    protected ItemStackHandlerPM createHandler() {
        return new ItemStackHandlerPM(this.items, (AbstractTilePM)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerOpt.invalidate();
    }

    public void addListener(ContainerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ContainerListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(ContainerListener listener) {
        this.listeners.remove(listener);
    }

    public ItemStack getItem(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    public ItemStack getSyncedStackInSlot(int index) {
        return (ItemStack)this.syncedItems.get(index);
    }

    public int getMaxStackSize(int index) {
        return this.itemHandler.getSlotLimit(index);
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack stack = this.itemHandler.extractItem(index, count, false);
        if (!stack.m_41619_() && this.isSyncedSlot(index)) {
            this.syncSlots(null);
        }
        this.m_6596_();
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        this.itemHandler.setStackInSlot(index, stack);
        this.m_6596_();
        if (this.isSyncedSlot(index)) {
            this.syncSlots(null);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.listeners != null) {
            RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)this.itemHandler);
            this.listeners.forEach(listener -> listener.m_5757_((Container)wrapper));
        }
    }

    protected boolean isSyncedSlot(int index) {
        return this.syncedSlotIndices.contains(index);
    }

    protected void syncSlots(@Nullable ServerPlayer player) {
        if (!this.syncedSlotIndices.isEmpty()) {
            CompoundTag nbt = new CompoundTag();
            ListTag tagList = new ListTag();
            for (int index = 0; index < this.items.size(); ++index) {
                ItemStack stack = (ItemStack)this.items.get(index);
                if (!this.isSyncedSlot(index) || stack.m_41619_()) continue;
                CompoundTag slotTag = new CompoundTag();
                slotTag.m_128344_("Slot", (byte)index);
                stack.m_41739_(slotTag);
                tagList.add((Object)slotTag);
            }
            nbt.m_128365_("ItemsSynced", (Tag)tagList);
            this.sendMessageToClient(nbt, player);
        }
    }

    @Override
    public void syncTile(boolean rerender) {
        super.syncTile(rerender);
        this.syncSlots(null);
    }

    @Override
    public void onMessageFromClient(CompoundTag nbt, ServerPlayer player) {
        super.onMessageFromClient(nbt, player);
        if (nbt.m_128441_("RequestSync")) {
            this.syncSlots(player);
        }
    }

    @Override
    public void onMessageFromServer(CompoundTag nbt) {
        super.onMessageFromServer(nbt);
        if (nbt.m_128441_("ItemsSynced")) {
            this.syncedItems = NonNullList.m_122780_((int)this.itemHandler.getSlots(), (Object)ItemStack.f_41583_);
            ListTag tagList = nbt.m_128437_("ItemsSynced", 10);
            for (int index = 0; index < tagList.size(); ++index) {
                CompoundTag slotTag = tagList.m_128728_(index);
                byte slotIndex = slotTag.m_128445_("Slot");
                if (!this.isSyncedSlot(slotIndex)) continue;
                this.syncedItems.set((int)slotIndex, (Object)ItemStack.m_41712_((CompoundTag)slotTag));
            }
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)compound, this.items);
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.items);
    }

    public void onLoad() {
        super.onLoad();
        this.doInventorySync();
    }

    protected void doInventorySync() {
        if (!this.f_58857_.f_46443_) {
            this.syncSlots(null);
        } else {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("RequestSync", true);
            this.sendMessageToServer(nbt);
        }
    }

    public void dropContents(Level level, BlockPos pos) {
        Containers.m_19010_((Level)level, (BlockPos)pos, this.items);
    }
}

