/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.base;

import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class AbstractTileSidedInventoryPM
extends AbstractTilePM {
    protected final NonNullList<NonNullList<ItemStack>> inventories;
    protected final NonNullList<NonNullList<ItemStack>> syncedInventories;
    protected final NonNullList<ItemStackHandler> itemHandlers;
    protected final NonNullList<LazyOptional<IItemHandler>> itemHandlerOpts;
    protected final NonNullList<List<ContainerListener>> listeners;

    public AbstractTileSidedInventoryPM(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        int index;
        for (Direction dir : Direction.values()) {
            this.getInventoryIndexForFace(dir).ifPresent(invIndex -> {
                if (invIndex < 0 || invIndex >= this.getInventoryCount()) {
                    throw new IllegalArgumentException("Face inventory mapping yields invalid index for direction " + dir.toString());
                }
            });
        }
        this.inventories = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)NonNullList.m_122779_());
        this.syncedInventories = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)NonNullList.m_122779_());
        for (index = 0; index < this.getInventoryCount(); ++index) {
            this.inventories.set(index, (Object)NonNullList.m_122780_((int)this.getInventorySize(index), (Object)ItemStack.f_41583_));
            this.syncedInventories.set(index, (Object)NonNullList.m_122780_((int)this.getInventorySize(index), (Object)ItemStack.f_41583_));
        }
        this.itemHandlers = this.createHandlers();
        this.itemHandlerOpts = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)LazyOptional.empty());
        for (index = 0; index < this.itemHandlers.size(); ++index) {
            int optIndex = index;
            this.itemHandlerOpts.set(index, (Object)LazyOptional.of(() -> (IItemHandler)this.itemHandlers.get(optIndex)));
        }
        this.listeners = NonNullList.m_122780_((int)this.getInventoryCount(), new ArrayList());
    }

    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return Collections.emptySet();
    }

    public int getInventorySize(Direction face) {
        MutableInt retVal = new MutableInt(0);
        this.getInventoryIndexForFace(face).ifPresent(invIndex -> retVal.setValue(this.getInventorySize(invIndex)));
        return retVal.getValue();
    }

    protected abstract int getInventoryCount();

    protected abstract int getInventorySize(int var1);

    protected abstract OptionalInt getInventoryIndexForFace(Direction var1);

    protected abstract NonNullList<ItemStackHandler> createHandlers();

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerOpts.forEach(opt -> opt.invalidate());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction face) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.getInventoryIndexForFace(face).isPresent()) {
                return ((LazyOptional)this.itemHandlerOpts.get(this.getInventoryIndexForFace(face).getAsInt())).cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, face);
    }

    public void addListener(Direction face, ContainerListener listener) {
        this.getInventoryIndexForFace(face).ifPresent(invIndex -> ((List)this.listeners.get(invIndex)).add(listener));
    }

    public void removeListener(ContainerListener listener) {
        this.listeners.forEach(invListeners -> invListeners.remove(listener));
    }

    public void m_6596_() {
        super.m_6596_();
        for (int index = 0; index < this.getInventoryCount(); ++index) {
            RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)this.itemHandlers.get(index));
            ((List)this.listeners.get(index)).forEach(listener -> listener.m_5757_((Container)wrapper));
        }
    }

    protected boolean isSyncedSlot(int inventoryIndex, int slotIndex) {
        return this.getSyncedSlotIndices(inventoryIndex).contains(slotIndex);
    }

    protected void syncSlots(@Nullable ServerPlayer player) {
        ListTag tagList = new ListTag();
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            for (int slotIndex = 0; slotIndex < this.getInventorySize(invIndex); ++slotIndex) {
                ItemStack stack = this.getItem(invIndex, slotIndex);
                if (!this.isSyncedSlot(invIndex, slotIndex) || stack.m_41619_()) continue;
                CompoundTag slotTag = new CompoundTag();
                slotTag.m_128344_("Inv", (byte)invIndex);
                slotTag.m_128344_("Slot", (byte)slotIndex);
                stack.m_41739_(slotTag);
                tagList.add((Object)slotTag);
            }
        }
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("ItemsSynced", (Tag)tagList);
        this.sendMessageToClient(nbt, player);
    }

    @Override
    public void syncTile(boolean rerender) {
        super.syncTile(rerender);
        this.syncSlots(null);
    }

    @Override
    public void onMessageFromClient(CompoundTag nbt, ServerPlayer player) {
        super.onMessageFromClient(nbt, player);
        if (nbt.m_128441_("RequestSync")) {
            this.syncSlots(player);
        }
    }

    @Override
    public void onMessageFromServer(CompoundTag nbt) {
        super.onMessageFromServer(nbt);
        if (nbt.m_128441_("ItemsSynced")) {
            for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
                ((NonNullList)this.syncedInventories.get(invIndex)).clear();
            }
            ListTag tagList = nbt.m_128437_("ItemsSynced", 10);
            for (int tagIndex = 0; tagIndex < tagList.size(); ++tagIndex) {
                byte slotIndex;
                CompoundTag slotTag = tagList.m_128728_(tagIndex);
                byte invIndex = slotTag.m_128445_("Inv");
                if (!this.isSyncedSlot(invIndex, slotIndex = slotTag.m_128445_("Slot"))) continue;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)slotTag);
                ((NonNullList)this.syncedInventories.get((int)invIndex)).set((int)slotIndex, (Object)stack);
            }
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            ((NonNullList)this.inventories.get(invIndex)).clear();
        }
        if (pTag.m_128441_("TileSidedInventoriesPM")) {
            ListTag listTag = pTag.m_128437_("TileSidedInventoriesPM", 10);
            for (int invIndex = 0; invIndex < this.getInventoryCount() && invIndex < listTag.size(); ++invIndex) {
                CompoundTag invTag = listTag.m_128728_(invIndex);
                ContainerHelper.m_18980_((CompoundTag)invTag, (NonNullList)((NonNullList)this.inventories.get(invIndex)));
            }
        } else if (pTag.m_128441_("Items")) {
            int legacySize = 0;
            for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
                legacySize += this.getInventorySize(invIndex);
            }
            NonNullList legacyItems = NonNullList.m_122780_((int)legacySize, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)pTag, (NonNullList)legacyItems);
            this.loadLegacyItems((NonNullList<ItemStack>)legacyItems);
        }
    }

    protected abstract void loadLegacyItems(NonNullList<ItemStack> var1);

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ListTag listTag = new ListTag();
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            CompoundTag invTag = new CompoundTag();
            ContainerHelper.m_18973_((CompoundTag)invTag, (NonNullList)((NonNullList)this.inventories.get(invIndex)));
            listTag.add(invIndex, (Tag)invTag);
        }
        pTag.m_128365_("TileSidedInventoriesPM", (Tag)listTag);
    }

    public void onLoad() {
        super.onLoad();
        this.doInventorySync();
    }

    protected void doInventorySync() {
        if (!this.f_58857_.f_46443_) {
            this.syncSlots(null);
        } else {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("RequestSync", true);
            this.sendMessageToServer(nbt);
        }
    }

    public void dropContents(Level level, BlockPos pos) {
        this.inventories.forEach(inv -> Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)inv));
    }

    public ItemStack getItem(int invIndex, int slotIndex) {
        return (ItemStack)((NonNullList)this.inventories.get(invIndex)).get(slotIndex);
    }

    public ItemStack getSyncedItem(int invIndex, int slotIndex) {
        return (ItemStack)((NonNullList)this.syncedInventories.get(invIndex)).get(slotIndex);
    }

    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ((ItemStackHandler)this.itemHandlers.get(invIndex)).setStackInSlot(slotIndex, stack);
    }
}

