/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.crafting;

import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.blocks.crafting.AbstractCalcinatorBlock;
import com.verdantartifice.primalmagick.common.capabilities.ITileResearchCache;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.capabilities.TileResearchCache;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.menus.CalcinatorMenu;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class AbstractCalcinatorTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IOwnedTileEntity {
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int FUEL_INV_INDEX = 1;
    protected static final int OUTPUT_INV_INDEX = 2;
    protected static final int OUTPUT_CAPACITY = 9;
    protected int burnTime;
    protected int burnTimeTotal;
    protected int cookTime;
    protected int cookTimeTotal;
    protected UUID ownerUUID;
    protected ITileResearchCache researchCache;
    protected LazyOptional<ITileResearchCache> researchCacheOpt = LazyOptional.of(() -> this.researchCache);
    protected Set<SimpleResearchKey> relevantResearch = Collections.emptySet();
    protected final Predicate<SimpleResearchKey> relevantFilter = k -> this.getRelevantResearch().contains(k);
    protected final ContainerData calcinatorData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return AbstractCalcinatorTileEntity.this.burnTime;
                }
                case 1: {
                    return AbstractCalcinatorTileEntity.this.burnTimeTotal;
                }
                case 2: {
                    return AbstractCalcinatorTileEntity.this.cookTime;
                }
                case 3: {
                    return AbstractCalcinatorTileEntity.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AbstractCalcinatorTileEntity.this.burnTime = value;
                    break;
                }
                case 1: {
                    AbstractCalcinatorTileEntity.this.burnTimeTotal = value;
                    break;
                }
                case 2: {
                    AbstractCalcinatorTileEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    AbstractCalcinatorTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public AbstractCalcinatorTileEntity(BlockEntityType<? extends AbstractCalcinatorTileEntity> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.researchCache = new TileResearchCache();
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0 -> 1;
            case 1 -> 1;
            case 2 -> 9;
            default -> 0;
        };
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP -> OptionalInt.of(0);
            case Direction.DOWN -> OptionalInt.of(2);
            default -> OptionalInt.of(1);
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), (AbstractTilePM)this));
        retVal.set(1, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(1), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return AbstractCalcinatorTileEntity.isFuel(stack);
            }
        });
        retVal.set(2, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(2), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
        this.setItem(1, 0, (ItemStack)legacyItems.get(1));
        for (int outputIndex = 0; outputIndex < 9; ++outputIndex) {
            this.setItem(2, outputIndex, (ItemStack)legacyItems.get(outputIndex + 2));
        }
    }

    protected boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        String ownerUUIDStr;
        super.m_142466_(compound);
        this.burnTime = compound.m_128451_("BurnTime");
        this.burnTimeTotal = compound.m_128451_("BurnTimeTotal");
        this.cookTime = compound.m_128451_("CookTime");
        this.cookTimeTotal = compound.m_128451_("CookTimeTotal");
        this.researchCache.deserializeNBT((Tag)compound.m_128469_("ResearchCache"));
        this.ownerUUID = null;
        if (compound.m_128441_("OwnerUUID") && !(ownerUUIDStr = compound.m_128461_("OwnerUUID")).isEmpty()) {
            this.ownerUUID = UUID.fromString(ownerUUIDStr);
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("BurnTime", this.burnTime);
        compound.m_128405_("BurnTimeTotal", this.burnTimeTotal);
        compound.m_128405_("CookTime", this.cookTime);
        compound.m_128405_("CookTimeTotal", this.cookTimeTotal);
        compound.m_128365_("ResearchCache", this.researchCache.serializeNBT());
        if (this.ownerUUID != null) {
            compound.m_128359_("OwnerUUID", this.ownerUUID.toString());
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            this.relevantResearch = AbstractCalcinatorTileEntity.assembleRelevantResearch();
        }
        this.cookTimeTotal = this.getCookTimeTotal();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractCalcinatorTileEntity entity) {
        boolean burningAtStart = entity.isBurning();
        boolean shouldMarkDirty = false;
        if (burningAtStart) {
            --entity.burnTime;
        }
        if (!level.f_46443_) {
            ItemStack inputStack = entity.getItem(0, 0);
            ItemStack fuelStack = entity.getItem(1, 0);
            if (entity.isBurning() || !fuelStack.m_41619_() && !inputStack.m_41619_()) {
                if (!entity.isBurning() && entity.canCalcinate(inputStack)) {
                    entity.burnTimeTotal = entity.burnTime = ForgeHooks.getBurnTime((ItemStack)fuelStack, null);
                    if (entity.isBurning()) {
                        shouldMarkDirty = true;
                        if (fuelStack.hasCraftingRemainingItem()) {
                            entity.setItem(1, 0, fuelStack.getCraftingRemainingItem());
                        } else if (!fuelStack.m_41619_()) {
                            fuelStack.m_41774_(1);
                            if (fuelStack.m_41619_()) {
                                entity.setItem(1, 0, fuelStack.getCraftingRemainingItem());
                            }
                        }
                    }
                }
                if (entity.isBurning() && entity.canCalcinate(inputStack)) {
                    ++entity.cookTime;
                    if (entity.cookTime == entity.cookTimeTotal) {
                        entity.cookTime = 0;
                        entity.cookTimeTotal = entity.getCookTimeTotal();
                        entity.doCalcination();
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.cookTime = 0;
                }
            } else if (!entity.isBurning() && entity.cookTime > 0) {
                entity.cookTime = Mth.m_14045_((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
            }
            if (burningAtStart != entity.isBurning()) {
                shouldMarkDirty = true;
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)AbstractCalcinatorBlock.LIT, (Comparable)Boolean.valueOf(entity.isBurning())), 3);
            }
        }
        if (shouldMarkDirty) {
            entity.m_6596_();
            entity.syncTile(true);
        }
    }

    protected void doCalcination() {
        ItemStack inputStack = this.getItem(0, 0);
        if (!inputStack.m_41619_() && this.canCalcinate(inputStack)) {
            List currentOutputs = (List)this.inventories.get(2);
            List<ItemStack> newOutputs = this.getCalcinationOutput(inputStack, false);
            List<ItemStack> mergedOutputs = ItemUtils.mergeItemStackLists(currentOutputs, newOutputs);
            for (int index = 0; index < Math.min(mergedOutputs.size(), 9); ++index) {
                ItemStack out = mergedOutputs.get(index);
                this.setItem(2, index, out == null ? ItemStack.f_41583_ : out);
            }
            inputStack.m_41774_(1);
        }
    }

    protected abstract int getCookTimeTotal();

    public static boolean isFuel(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, null) > 0;
    }

    protected boolean canCalcinate(ItemStack inputStack) {
        MutableBoolean retVal = new MutableBoolean(false);
        if (inputStack != null && !inputStack.m_41619_()) {
            AffinityManager.getInstance().getAffinityValues(inputStack, this.f_58857_).ifPresent(sources -> {
                if (!sources.isEmpty()) {
                    List<ItemStack> newOutputs;
                    List currentOutputs = (List)this.inventories.get(2);
                    List<ItemStack> mergedOutputs = ItemUtils.mergeItemStackLists(currentOutputs, newOutputs = this.getCalcinationOutput(inputStack, true));
                    retVal.setValue(mergedOutputs.size() <= 9);
                }
            });
        }
        return retVal.booleanValue();
    }

    @Nonnull
    protected abstract List<ItemStack> getCalcinationOutput(ItemStack var1, boolean var2);

    @Nonnull
    protected ItemStack getOutputEssence(EssenceType type, Source source, int count) {
        if (this.isSourceKnown(source)) {
            return EssenceItem.getEssence(type, source, count);
        }
        return new ItemStack((ItemLike)ItemsPM.ALCHEMICAL_WASTE.get(), count);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new CalcinatorMenu(windowId, playerInv, this.m_58899_(), this, this.calcinatorData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.cookTimeTotal = this.getCookTimeTotal();
            this.cookTime = 0;
            this.m_6596_();
        }
    }

    @Override
    public void setTileOwner(Player owner) {
        this.ownerUUID = owner.m_20148_();
        this.researchCache.update(owner, this.relevantFilter);
    }

    @Override
    public Player getTileOwner() {
        Level level;
        if (this.ownerUUID != null && this.m_58898_() && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer livePlayer = serverLevel.m_7654_().m_6846_().m_11259_(this.ownerUUID);
            if (livePlayer != null && livePlayer.f_19797_ % 20 == 0) {
                this.researchCache.update((Player)livePlayer, this.relevantFilter);
            }
            return livePlayer;
        }
        return null;
    }

    protected boolean isSourceKnown(@Nullable Source source) {
        if (source == null || source.getDiscoverKey() == null) {
            return true;
        }
        Player owner = this.getTileOwner();
        if (owner != null) {
            return source.isDiscovered(owner);
        }
        return this.researchCache.isResearchComplete(source.getDiscoverKey());
    }

    protected Set<SimpleResearchKey> getRelevantResearch() {
        return this.relevantResearch;
    }

    protected static Set<SimpleResearchKey> assembleRelevantResearch() {
        return Source.SORTED_SOURCES.stream().map(s -> s.getDiscoverKey()).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == PrimalMagickCapabilities.RESEARCH_CACHE) {
            return this.researchCacheOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.researchCacheOpt.invalidate();
    }
}

