/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.crafting;

import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.blocks.crafting.CalcinatorBlock;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.crafting.AbstractCalcinatorTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CalcinatorTileEntity
extends AbstractCalcinatorTileEntity {
    public CalcinatorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractCalcinatorTileEntity>)((BlockEntityType)TileEntityTypesPM.CALCINATOR.get()), pos, state);
    }

    @Override
    protected int getCookTimeTotal() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof CalcinatorBlock) {
            CalcinatorBlock calcinatorBlock = (CalcinatorBlock)block;
            return switch (calcinatorBlock.getDeviceTier()) {
                case DeviceTier.BASIC -> 160;
                case DeviceTier.ENCHANTED -> 120;
                case DeviceTier.FORBIDDEN -> 80;
                case DeviceTier.HEAVENLY -> 40;
                default -> 200;
            };
        }
        throw new IllegalStateException("Unknown block type " + block);
    }

    @Override
    @Nonnull
    protected List<ItemStack> getCalcinationOutput(ItemStack inputStack, boolean alwaysGenerateDregs) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        EssenceType maxEssenceType = this.getMaxOutputEssenceType();
        AffinityManager.getInstance().getAffinityValues(inputStack, this.f_58857_).filter(Predicate.not(SourceList::isEmpty)).ifPresent(sources -> {
            for (Source source : Source.SORTED_SOURCES) {
                ItemStack stack;
                int amount = sources.getAmount(source);
                if (amount <= 0) continue;
                EssenceType currentEssenceType = maxEssenceType;
                while (currentEssenceType != null) {
                    if (amount >= currentEssenceType.getAffinity()) {
                        int count = amount / currentEssenceType.getAffinity();
                        ItemStack stack2 = this.getOutputEssence(currentEssenceType, source, count);
                        if (stack2.m_41619_()) continue;
                        output.add(stack2);
                        break;
                    }
                    currentEssenceType = currentEssenceType.getDowngrade();
                }
                if (currentEssenceType != null || amount <= 0 || !alwaysGenerateDregs && this.f_58857_.f_46441_.m_188503_(EssenceType.DUST.getAffinity()) >= amount || (stack = this.getOutputEssence(EssenceType.DUST, source, 1)).m_41619_()) continue;
                output.add(stack);
            }
        });
        return output;
    }

    @Nonnull
    protected EssenceType getMaxOutputEssenceType() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof CalcinatorBlock) {
            CalcinatorBlock calcinatorBlock = (CalcinatorBlock)block;
            return switch (calcinatorBlock.getDeviceTier()) {
                case DeviceTier.BASIC -> EssenceType.DUST;
                case DeviceTier.ENCHANTED -> EssenceType.SHARD;
                case DeviceTier.FORBIDDEN -> EssenceType.CRYSTAL;
                case DeviceTier.HEAVENLY -> EssenceType.CLUSTER;
                default -> EssenceType.DUST;
            };
        }
        throw new IllegalStateException("Unknown block type " + block);
    }
}

