/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.crafting;

import com.verdantartifice.primalmagick.common.blocks.crafting.ConcocterBlock;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ITileResearchCache;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.capabilities.TileResearchCache;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionUtils;
import com.verdantartifice.primalmagick.common.concoctions.FuseType;
import com.verdantartifice.primalmagick.common.crafting.IConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.menus.ConcocterMenu;
import com.verdantartifice.primalmagick.common.research.CompoundResearchKey;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.IManaContainer;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.Collections;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class ConcocterTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IOwnedTileEntity,
IManaContainer,
StackedContentsCompatible {
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int WAND_INV_INDEX = 1;
    protected static final int OUTPUT_INV_INDEX = 2;
    protected static final int MAX_INPUT_ITEMS = 9;
    protected int cookTime;
    protected int cookTimeTotal;
    protected ManaStorage manaStorage;
    protected ITileResearchCache researchCache;
    protected UUID ownerUUID;
    protected LazyOptional<IManaStorage> manaStorageOpt = LazyOptional.of(() -> this.manaStorage);
    protected LazyOptional<ITileResearchCache> researchCacheOpt = LazyOptional.of(() -> this.researchCache);
    protected Set<SimpleResearchKey> relevantResearch = Collections.emptySet();
    protected final Predicate<SimpleResearchKey> relevantFilter = k -> this.getRelevantResearch().contains(k);
    protected final ContainerData concocterData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return ConcocterTileEntity.this.cookTime;
                }
                case 1: {
                    return ConcocterTileEntity.this.cookTimeTotal;
                }
                case 2: {
                    return ConcocterTileEntity.this.manaStorage.getManaStored(Source.INFERNAL);
                }
                case 3: {
                    return ConcocterTileEntity.this.manaStorage.getMaxManaStored(Source.INFERNAL);
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ConcocterTileEntity.this.cookTime = value;
                    break;
                }
                case 1: {
                    ConcocterTileEntity.this.cookTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public ConcocterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.CONCOCTER.get(), pos, state);
        this.manaStorage = new ManaStorage(10000, 1000, 1000, Source.INFERNAL);
        this.researchCache = new TileResearchCache();
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cookTime = compound.m_128451_("CookTime");
        this.cookTimeTotal = compound.m_128451_("CookTimeTotal");
        this.manaStorage.deserializeNBT(compound.m_128469_("ManaStorage"));
        this.researchCache.deserializeNBT((Tag)compound.m_128469_("ResearchCache"));
        this.ownerUUID = null;
        if (compound.m_128441_("OwnerUUID")) {
            this.ownerUUID = compound.m_128342_("OwnerUUID");
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("CookTime", this.cookTime);
        compound.m_128405_("CookTimeTotal", this.cookTimeTotal);
        compound.m_128365_("ManaStorage", (Tag)this.manaStorage.serializeNBT());
        compound.m_128365_("ResearchCache", this.researchCache.serializeNBT());
        if (this.ownerUUID != null) {
            compound.m_128362_("OwnerUUID", this.ownerUUID);
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new ConcocterMenu(windowId, playerInv, this.m_58899_(), this, this.concocterData);
    }

    @Override
    public void setTileOwner(Player owner) {
        this.ownerUUID = owner.m_20148_();
        this.researchCache.update(owner, this.relevantFilter);
    }

    @Override
    public Player getTileOwner() {
        Level level;
        if (this.ownerUUID != null && this.m_58898_() && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer livePlayer = serverLevel.m_7654_().m_6846_().m_11259_(this.ownerUUID);
            if (livePlayer != null && livePlayer.f_19797_ % 20 == 0) {
                this.researchCache.update((Player)livePlayer, this.relevantFilter);
            }
            return livePlayer;
        }
        return null;
    }

    protected boolean isResearchKnown(@Nullable CompoundResearchKey key) {
        if (key == null) {
            return true;
        }
        Player owner = this.getTileOwner();
        if (owner != null) {
            return key.isKnownByStrict(owner);
        }
        return this.researchCache.isResearchComplete(key);
    }

    protected Set<SimpleResearchKey> getRelevantResearch() {
        return this.relevantResearch;
    }

    protected static Set<SimpleResearchKey> assembleRelevantResearch(Level level) {
        return level.m_7465_().m_44013_((RecipeType)RecipeTypesPM.CONCOCTING.get()).stream().map(r -> r.getRequiredResearch().getKeys()).flatMap(l -> l.stream()).distinct().collect(Collectors.toUnmodifiableSet());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            this.relevantResearch = ConcocterTileEntity.assembleRelevantResearch(this.f_58857_);
        }
        this.cookTimeTotal = this.getCookTimeTotal();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ConcocterTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.f_46443_) {
            int centimanaMissing;
            int centimanaToTransfer;
            IWand wand;
            ItemStack wandStack = entity.getItem(1, 0);
            if (!wandStack.m_41619_() && wandStack.m_41720_() instanceof IWand && (wand = (IWand)wandStack.m_41720_()).consumeMana(wandStack, null, Source.INFERNAL, centimanaToTransfer = Mth.m_14045_((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Source.INFERNAL) - entity.manaStorage.getManaStored(Source.INFERNAL)), (int)0, (int)100))) {
                entity.manaStorage.receiveMana(Source.INFERNAL, centimanaToTransfer, false);
                shouldMarkDirty = true;
            }
            SimpleContainer realInv = new SimpleContainer(9);
            SimpleContainer testInv = new SimpleContainer(9);
            for (int index = 0; index < 9; ++index) {
                ItemStack invStack = entity.getItem(0, index);
                realInv.m_6836_(index, invStack);
                testInv.m_6836_(index, ConcoctionUtils.isBomb(invStack) ? ConcoctionUtils.setFuseType(invStack.m_41777_(), FuseType.MEDIUM) : invStack);
            }
            IConcoctingRecipe recipe = level.m_7654_().m_129894_().m_44015_((RecipeType)RecipeTypesPM.CONCOCTING.get(), (Container)testInv, level).orElse(null);
            if (entity.canConcoct((Container)realInv, level.m_9598_(), recipe)) {
                ++entity.cookTime;
                if (entity.cookTime >= entity.cookTimeTotal) {
                    entity.cookTime = 0;
                    entity.cookTimeTotal = entity.getCookTimeTotal();
                    entity.doConcoction((Container)realInv, level.m_9598_(), recipe);
                    shouldMarkDirty = true;
                }
            } else {
                entity.cookTime = Mth.m_14045_((int)(entity.cookTime - 2), (int)0, (int)entity.cookTimeTotal);
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ConcocterBlock.HAS_BOTTLE, (Comparable)Boolean.valueOf(entity.showBottle())), 2);
        }
        if (shouldMarkDirty) {
            entity.m_6596_();
            entity.syncTile(true);
        }
    }

    protected boolean canConcoct(Container inputInv, RegistryAccess registryAccess, @Nullable IConcoctingRecipe recipe) {
        if (!inputInv.m_7983_() && recipe != null) {
            ItemStack output = recipe.m_8043_(registryAccess);
            if (output.m_41619_()) {
                return false;
            }
            if (this.getMana(Source.INFERNAL) < 100 * recipe.getManaCosts().getAmount(Source.INFERNAL)) {
                return false;
            }
            if (!this.isResearchKnown(recipe.getRequiredResearch())) {
                return false;
            }
            ItemStack currentOutput = this.getItem(2, 0);
            if (currentOutput.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)currentOutput, (ItemStack)output)) {
                return false;
            }
            if (currentOutput.m_41613_() + output.m_41613_() <= ((ItemStackHandler)this.itemHandlers.get(2)).getSlotLimit(0) && currentOutput.m_41613_() + output.m_41613_() <= currentOutput.m_41741_()) {
                return true;
            }
            return currentOutput.m_41613_() + output.m_41613_() <= output.m_41741_();
        }
        return false;
    }

    protected void doConcoction(Container inputInv, RegistryAccess registryAccess, @Nullable IConcoctingRecipe recipe) {
        if (recipe != null && this.canConcoct(inputInv, registryAccess, recipe)) {
            ItemStack recipeOutput = recipe.m_5874_(inputInv, registryAccess);
            ItemStack currentOutput = this.getItem(2, 0);
            if (currentOutput.m_41619_()) {
                this.setItem(2, 0, recipeOutput);
            } else if (ItemStack.m_150942_((ItemStack)recipeOutput, (ItemStack)currentOutput)) {
                currentOutput.m_41769_(recipeOutput.m_41613_());
            }
            for (int index = 0; index < inputInv.m_6643_(); ++index) {
                ItemStack stack = inputInv.m_8020_(index);
                if (stack.m_41619_()) continue;
                stack.m_41774_(1);
            }
            this.setMana(Source.INFERNAL, this.getMana(Source.INFERNAL) - 100 * recipe.getManaCosts().getAmount(Source.INFERNAL));
        }
    }

    protected boolean showBottle() {
        return this.cookTime > 0 || !this.getItem(2, 0).m_41619_();
    }

    protected int getCookTimeTotal() {
        return 100;
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.manaStorageOpt.invalidate();
        this.researchCacheOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == PrimalMagickCapabilities.MANA_STORAGE) {
            return this.manaStorageOpt.cast();
        }
        if (!this.f_58859_ && cap == PrimalMagickCapabilities.RESEARCH_CACHE) {
            return this.researchCacheOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Source.SORTED_SOURCES) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Source.INFERNAL);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.cookTimeTotal = this.getCookTimeTotal();
            this.cookTime = 0;
            this.m_6596_();
        }
    }

    public void m_5809_(StackedContents stackedContents) {
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            for (int slotIndex = 0; slotIndex < this.getInventorySize(invIndex); ++slotIndex) {
                stackedContents.m_36491_(this.getItem(invIndex, slotIndex));
            }
        }
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0 -> 9;
            case 1 -> 1;
            case 2 -> 1;
            default -> 0;
        };
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP -> OptionalInt.of(0);
            case Direction.DOWN -> OptionalInt.of(2);
            default -> OptionalInt.of(1);
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList<ItemStack>)((NonNullList)this.inventories.get(0)), (AbstractTilePM)this));
        retVal.set(1, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(1), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof IWand;
            }
        });
        retVal.set(2, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(2), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        for (int inputIndex = 0; inputIndex < 9; ++inputIndex) {
            this.setItem(0, inputIndex, (ItemStack)legacyItems.get(inputIndex));
        }
        this.setItem(1, 0, (ItemStack)legacyItems.get(9));
        this.setItem(2, 0, (ItemStack)legacyItems.get(10));
    }
}

