/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.crafting;

import com.verdantartifice.primalmagick.common.blocks.crafting.SpellcraftingAltarBlock;
import com.verdantartifice.primalmagick.common.menus.SpellcraftingAltarMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.SpellcraftingRunePacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SpellcraftingAltarTileEntity
extends AbstractTilePM
implements MenuProvider {
    public static final int BOB_CYCLE_TIME_TICKS = 200;
    protected static final int TICKS_PER_SEGMENT_ROTATION = 10;
    protected static final int TICKS_PER_PAUSE = 20;
    protected static final List<Source> ALLOWED_SOURCES = Arrays.asList(Source.EARTH, Source.SEA, Source.SKY, Source.SUN, Source.MOON);
    protected int phaseTicks = 0;
    protected int nextUpdate = 0;
    protected Segment lastSegment = Segment.U1;
    protected Segment nextSegment = Segment.U1;
    protected RotationPhase currentRotation = RotationPhase.COUNTER_CLOCKWISE_PAUSE;
    protected Source lastSource = Source.EARTH;
    protected Source nextSource = Source.EARTH;

    public SpellcraftingAltarTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.SPELLCRAFTING_ALTAR.get(), pos, state);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new SpellcraftingAltarMenu(windowId, playerInv, this.m_58899_(), this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.phaseTicks = compound.m_128451_("PhaseTicks");
        this.nextUpdate = compound.m_128451_("NextUpdate");
        this.lastSegment = Segment.values()[compound.m_128451_("LastSegmentIndex")];
        this.nextSegment = Segment.values()[compound.m_128451_("NextSegmentIndex")];
        this.currentRotation = RotationPhase.values()[compound.m_128451_("CurrentRotationIndex")];
        Source last = Source.getSource(compound.m_128461_("LastSource"));
        this.lastSource = last == null ? Source.EARTH : last;
        Source next = Source.getSource(compound.m_128461_("NextSource"));
        this.nextSource = next == null ? Source.EARTH : next;
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("PhaseTicks", this.phaseTicks);
        compound.m_128405_("NextUpdate", this.nextUpdate);
        compound.m_128405_("LastSegmentIndex", this.lastSegment.ordinal());
        compound.m_128405_("NextSegmentIndex", this.nextSegment.ordinal());
        compound.m_128405_("CurrentRotationIndex", this.currentRotation.ordinal());
        compound.m_128359_("LastSource", this.lastSource.getTag());
        compound.m_128359_("NextSource", this.nextSource.getTag());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SpellcraftingAltarTileEntity entity) {
        if (entity.phaseTicks++ >= entity.nextUpdate && !level.f_46443_) {
            entity.nextRotationPhase();
        }
    }

    protected void nextRotationPhase() {
        this.currentRotation = this.currentRotation.getNext();
        if (!this.currentRotation.isPause()) {
            this.lastSegment = this.nextSegment;
            Segment[] nextPossibleSegments = (Segment[])Arrays.stream(Segment.values()).filter(s -> !s.equals((Object)this.lastSegment)).toArray(Segment[]::new);
            this.nextSegment = nextPossibleSegments[this.f_58857_.f_46441_.m_188503_(nextPossibleSegments.length)];
            this.lastSource = this.nextSource;
            Source[] nextPossibleSources = (Source[])ALLOWED_SOURCES.stream().filter(s -> !s.equals(this.lastSource)).toArray(Source[]::new);
            this.nextSource = nextPossibleSources[this.f_58857_.f_46441_.m_188503_(nextPossibleSources.length)];
        }
        this.nextUpdate = this.currentRotation.getDuration(this.lastSegment, this.nextSegment);
        this.phaseTicks = 0;
        this.m_6596_();
        this.syncTile(true);
        if (!this.f_58857_.f_46443_ && this.currentRotation.isPause()) {
            this.emitRuneParticle();
        }
    }

    public float getCurrentRotation(float partialTicks) {
        if (this.nextUpdate == 0) {
            return 0.0f;
        }
        if (this.currentRotation.isPause()) {
            return this.nextSegment.getDegreeOffset();
        }
        return Mth.m_14179_((float)(((float)this.phaseTicks + partialTicks) / (float)this.nextUpdate), (float)this.lastSegment.getDegreeOffset(), (float)this.nextSegment.getDegreeTarget(this.lastSegment, this.currentRotation));
    }

    public Color getCurrentColor(float partialTicks) {
        if (this.nextUpdate == 0) {
            return new Color(Source.EARTH.getColor());
        }
        if (this.currentRotation.isPause()) {
            return new Color(this.nextSource.getColor());
        }
        Color last = new Color(this.lastSource.getColor());
        Color next = new Color(this.nextSource.getColor());
        float blend = ((float)this.phaseTicks + partialTicks) / (float)this.nextUpdate;
        float inverse = 1.0f - blend;
        float r = (float)next.getRed() * blend + (float)last.getRed() * inverse;
        float g = (float)next.getGreen() * blend + (float)last.getGreen() * inverse;
        float b = (float)next.getBlue() * blend + (float)last.getBlue() * inverse;
        return new Color(Mth.m_14036_((float)(r / 255.0f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(g / 255.0f), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(b / 255.0f), (float)0.0f, (float)1.0f));
    }

    protected void emitRuneParticle() {
        Vec3 center = Vec3.m_82514_((Vec3i)this.f_58858_, (double)1.1875);
        Vec3 facingNormal = Vec3.m_82528_((Vec3i)((Direction)this.m_58900_().m_61143_((Property)SpellcraftingAltarBlock.FACING)).m_122436_());
        Vec3 centerOffset = facingNormal.m_82490_(0.5);
        Vec3 movement = facingNormal.m_82490_(0.05);
        long time = this.m_58904_().m_6106_().m_6793_();
        double bobDelta = 0.125 * Math.sin((double)time * 0.031415926535897934);
        PacketHandler.sendToAllAround(new SpellcraftingRunePacket(this.nextSegment, center.f_82479_ + centerOffset.f_82479_, center.f_82480_ + bobDelta, center.f_82481_ + centerOffset.f_82481_, movement.f_82479_, 0.0, movement.f_82481_, this.nextSource.getColor()), (ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_, 64.0);
    }

    public static enum Segment {
        U1(0),
        V1(45),
        T1(90),
        D1(135),
        U2(180),
        V2(225),
        T2(270),
        D2(315);

        private final int degreeOffset;

        private Segment(int degrees) {
            this.degreeOffset = degrees;
        }

        public int getDegreeOffset() {
            return this.degreeOffset;
        }

        public int getDegreeTarget(Segment last, RotationPhase rotation) {
            if (rotation.isReverse() && this.degreeOffset >= last.degreeOffset) {
                return this.degreeOffset - 360;
            }
            if (!rotation.isReverse() && this.degreeOffset <= last.degreeOffset) {
                return this.degreeOffset + 360;
            }
            return this.degreeOffset;
        }
    }

    protected static enum RotationPhase {
        CLOCKWISE(false, false),
        CLOCKWISE_PAUSE(false, true),
        COUNTER_CLOCKWISE(true, false),
        COUNTER_CLOCKWISE_PAUSE(true, true);

        private final boolean reverse;
        private final boolean pause;

        private RotationPhase(boolean reverse, boolean pause) {
            this.reverse = reverse;
            this.pause = pause;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public boolean isPause() {
            return this.pause;
        }

        public int getDuration(Segment last, Segment next) {
            switch (this) {
                case CLOCKWISE: 
                case COUNTER_CLOCKWISE: {
                    int segmentDelta = Math.abs(next.getDegreeTarget(last, this) - last.getDegreeOffset()) / 45;
                    return 10 * segmentDelta;
                }
                case CLOCKWISE_PAUSE: 
                case COUNTER_CLOCKWISE_PAUSE: {
                    return 20;
                }
            }
            throw new IndexOutOfBoundsException("No such rotation phase!");
        }

        public RotationPhase getNext() {
            switch (this) {
                case CLOCKWISE: {
                    return CLOCKWISE_PAUSE;
                }
                case CLOCKWISE_PAUSE: {
                    return COUNTER_CLOCKWISE;
                }
                case COUNTER_CLOCKWISE: {
                    return COUNTER_CLOCKWISE_PAUSE;
                }
                case COUNTER_CLOCKWISE_PAUSE: {
                    return CLOCKWISE;
                }
            }
            throw new IndexOutOfBoundsException("No such rotation phase!");
        }
    }
}

