/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeTypesPM;
import com.verdantartifice.primalmagick.common.menus.DissolutionChamberMenu;
import com.verdantartifice.primalmagick.common.sources.IManaContainer;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class DissolutionChamberTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainer,
StackedContentsCompatible {
    protected static final int OUTPUT_INV_INDEX = 0;
    protected static final int INPUT_INV_INDEX = 1;
    protected static final int WAND_INV_INDEX = 2;
    protected int processTime;
    protected int processTimeTotal;
    protected ManaStorage manaStorage;
    protected LazyOptional<IManaStorage> manaStorageOpt = LazyOptional.of(() -> this.manaStorage);
    protected final ContainerData chamberData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return DissolutionChamberTileEntity.this.processTime;
                }
                case 1: {
                    return DissolutionChamberTileEntity.this.processTimeTotal;
                }
                case 2: {
                    return DissolutionChamberTileEntity.this.manaStorage.getManaStored(Source.EARTH);
                }
                case 3: {
                    return DissolutionChamberTileEntity.this.manaStorage.getMaxManaStored(Source.EARTH);
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    DissolutionChamberTileEntity.this.processTime = value;
                    break;
                }
                case 1: {
                    DissolutionChamberTileEntity.this.processTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public DissolutionChamberTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.DISSOLUTION_CHAMBER.get(), pos, state);
        this.manaStorage = new ManaStorage(25600, 100, 100, Source.EARTH);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.processTime = compound.m_128451_("ProcessTime");
        this.processTimeTotal = compound.m_128451_("ProcessTimeTotal");
        this.manaStorage.deserializeNBT(compound.m_128469_("ManaStorage"));
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ProcessTime", this.processTime);
        compound.m_128405_("ProcessTimeTotal", this.processTimeTotal);
        compound.m_128365_("ManaStorage", (Tag)this.manaStorage.serializeNBT());
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new DissolutionChamberMenu(windowId, playerInv, this.m_58899_(), this, this.chamberData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    protected int getProcessTimeTotal() {
        return 100;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.processTimeTotal = this.getProcessTimeTotal();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DissolutionChamberTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.f_46443_) {
            int centimanaMissing;
            int centimanaToTransfer;
            IWand wand;
            Item item;
            ItemStack wandStack = entity.getItem(2, 0);
            if (!wandStack.m_41619_() && (item = wandStack.m_41720_()) instanceof IWand && (wand = (IWand)item).consumeMana(wandStack, null, Source.EARTH, centimanaToTransfer = Mth.m_14045_((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Source.EARTH) - entity.manaStorage.getManaStored(Source.EARTH)), (int)0, (int)100))) {
                entity.manaStorage.receiveMana(Source.EARTH, centimanaToTransfer, false);
                shouldMarkDirty = true;
            }
            SimpleContainer testInv = new SimpleContainer(new ItemStack[]{entity.getItem(1, 0)});
            IDissolutionRecipe recipe = level.m_7654_().m_129894_().m_44015_((RecipeType)RecipeTypesPM.DISSOLUTION.get(), (Container)testInv, level).orElse(null);
            if (entity.canDissolve((Container)testInv, level.m_9598_(), recipe)) {
                ++entity.processTime;
                if (entity.processTime >= entity.processTimeTotal) {
                    entity.processTime = 0;
                    entity.processTimeTotal = entity.getProcessTimeTotal();
                    entity.doDissolve((Container)testInv, level.m_9598_(), recipe);
                    shouldMarkDirty = true;
                }
            } else {
                entity.processTime = Mth.m_14045_((int)(entity.processTime - 2), (int)0, (int)entity.processTimeTotal);
            }
        }
        if (shouldMarkDirty) {
            entity.m_6596_();
            entity.syncTile(true);
        }
    }

    protected boolean canDissolve(Container inputInv, RegistryAccess registryAccess, IDissolutionRecipe recipe) {
        if (!inputInv.m_7983_() && recipe != null) {
            ItemStack output = recipe.m_8043_(registryAccess);
            if (output.m_41619_()) {
                return false;
            }
            if (this.getMana(Source.EARTH) < 100 * recipe.getManaCosts().getAmount(Source.EARTH)) {
                return false;
            }
            ItemStack currentOutput = this.getItem(0, 0);
            if (currentOutput.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)currentOutput, (ItemStack)output)) {
                return false;
            }
            if (currentOutput.m_41613_() + output.m_41613_() <= ((ItemStackHandler)this.itemHandlers.get(0)).getSlotLimit(0) && currentOutput.m_41613_() + output.m_41613_() <= currentOutput.m_41741_()) {
                return true;
            }
            return currentOutput.m_41613_() + output.m_41613_() <= output.m_41741_();
        }
        return false;
    }

    protected void doDissolve(Container inputInv, RegistryAccess registryAccess, IDissolutionRecipe recipe) {
        if (recipe != null && this.canDissolve(inputInv, registryAccess, recipe)) {
            ItemStack recipeOutput = recipe.m_5874_(inputInv, registryAccess);
            ItemStack currentOutput = this.getItem(0, 0);
            if (currentOutput.m_41619_()) {
                this.setItem(0, 0, recipeOutput);
            } else if (ItemStack.m_150942_((ItemStack)recipeOutput, (ItemStack)currentOutput)) {
                currentOutput.m_41769_(recipeOutput.m_41613_());
            }
            for (int index = 0; index < inputInv.m_6643_(); ++index) {
                ItemStack stack = inputInv.m_8020_(index);
                if (stack.m_41619_()) continue;
                stack.m_41774_(1);
            }
            this.setMana(Source.EARTH, this.getMana(Source.EARTH) - 100 * recipe.getManaCosts().getAmount(Source.EARTH));
        }
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 1 && (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack))) {
            this.processTimeTotal = this.getProcessTimeTotal();
            this.processTime = 0;
            this.m_6596_();
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == PrimalMagickCapabilities.MANA_STORAGE) {
            return this.manaStorageOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.manaStorageOpt.invalidate();
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Source.SORTED_SOURCES) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Source.EARTH);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.m_6596_();
        this.syncTile(true);
    }

    public void m_5809_(StackedContents stackedContents) {
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            for (int slotIndex = 0; slotIndex < this.getInventorySize(invIndex); ++slotIndex) {
                stackedContents.m_36491_(this.getItem(invIndex, slotIndex));
            }
        }
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 1, 2 -> 1;
            default -> 0;
        };
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP -> OptionalInt.of(1);
            case Direction.DOWN -> OptionalInt.of(0);
            default -> OptionalInt.of(2);
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(1, (Object)new ItemStackHandlerPM((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), (AbstractTilePM)this));
        retVal.set(2, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(2), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof IWand;
            }
        });
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
        this.setItem(1, 0, (ItemStack)legacyItems.get(1));
        this.setItem(2, 0, (ItemStack)legacyItems.get(2));
    }
}

