/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.verdantartifice.primalmagick.common.blocks.devices.EssenceCaskBlock;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.menus.EssenceCaskMenu;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.misc.ITieredDevice;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class EssenceCaskTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider {
    public static final int NUM_ROWS = EssenceType.values().length;
    public static final int NUM_COLS = Source.SORTED_SOURCES.size();
    public static final int NUM_SLOTS = NUM_ROWS * NUM_COLS;
    protected static final int INPUT_INV_INDEX = 0;
    protected static final Map<DeviceTier, Integer> CAPACITY = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(DeviceTier.ENCHANTED, 4096);
        map.put(DeviceTier.FORBIDDEN, 8192);
        map.put(DeviceTier.HEAVENLY, 16384);
    });
    protected final Table<EssenceType, Source, Integer> contents = HashBasedTable.create((int)NUM_ROWS, (int)NUM_COLS);
    protected final ContainerData caskData = new ContainerData(){

        public int m_6413_(int index) {
            return EssenceCaskTileEntity.this.getEssenceCountAtSlot(index);
        }

        public void m_8050_(int index, int value) {
            EssenceCaskTileEntity.this.setEssenceCountAtSlot(index, value);
        }

        public int m_6499_() {
            return NUM_SLOTS;
        }
    };
    protected final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            level.m_5594_(null, pos, SoundEvents.f_11725_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)EssenceCaskBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            level.m_5594_(null, pos, SoundEvents.f_11724_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)EssenceCaskBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int previousCount, int currentCount) {
        }

        protected boolean m_142718_(Player player) {
            EssenceCaskMenu caskMenu;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            return abstractContainerMenu instanceof EssenceCaskMenu && (caskMenu = (EssenceCaskMenu)abstractContainerMenu).getTile() == EssenceCaskTileEntity.this;
        }
    };

    public EssenceCaskTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.ESSENCE_CASK.get(), pos, state);
        for (EssenceType row : EssenceType.values()) {
            for (Source col : Source.SORTED_SOURCES) {
                this.contents.put((Object)row, (Object)col, (Object)0);
            }
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EssenceCaskTileEntity entity) {
        ItemStack stack;
        Item item;
        if (!level.f_46443_ && !((NonNullList)entity.inventories.get(0)).isEmpty() && (item = (stack = entity.getItem(0, 0)).m_41720_()) instanceof EssenceItem) {
            int capacity;
            EssenceItem essenceItem = (EssenceItem)item;
            EssenceType essenceType = essenceItem.getEssenceType();
            Source essenceSource = essenceItem.getSource();
            int inputCount = stack.m_41613_();
            int currentCount = entity.contents.contains((Object)essenceType, (Object)essenceSource) ? (Integer)entity.contents.get((Object)essenceType, (Object)essenceSource) : 0;
            int totalCount = entity.getTotalEssenceCount();
            if (totalCount + inputCount <= (capacity = entity.getTotalEssenceCapacity())) {
                entity.contents.put((Object)essenceType, (Object)essenceSource, (Object)(currentCount + inputCount));
                entity.setItem(0, 0, ItemStack.f_41583_);
            } else {
                int addable = capacity - totalCount;
                entity.contents.put((Object)essenceType, (Object)essenceSource, (Object)(currentCount + addable));
                stack.m_41774_(addable);
            }
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new EssenceCaskMenu(windowId, playerInv, this.m_58899_(), this, this.caskData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    protected DeviceTier getDeviceTier() {
        DeviceTier deviceTier;
        Block block = this.m_58900_().m_60734_();
        if (block instanceof ITieredDevice) {
            ITieredDevice device = (ITieredDevice)block;
            deviceTier = device.getDeviceTier();
        } else {
            deviceTier = null;
        }
        return deviceTier;
    }

    public int getTotalEssenceCapacity() {
        return CAPACITY.getOrDefault((Object)this.getDeviceTier(), 0);
    }

    public int getTotalEssenceCount() {
        return this.contents.values().stream().mapToInt(i -> i).sum();
    }

    public int getEssenceCountForType(EssenceType type) {
        return this.contents.row((Object)type).entrySet().stream().mapToInt(e -> (Integer)e.getValue()).sum();
    }

    public int getEssenceCountForSource(Source source) {
        return this.contents.column((Object)source).entrySet().stream().mapToInt(e -> (Integer)e.getValue()).sum();
    }

    protected EssenceType getEssenceTypeForIndex(int index) {
        return index < 0 || index >= NUM_SLOTS ? null : EssenceType.values()[index / NUM_COLS];
    }

    protected Source getEssenceSourceForIndex(int index) {
        return index < 0 || index >= NUM_SLOTS ? null : Source.SORTED_SOURCES.get(index % NUM_COLS);
    }

    public int getEssenceCount(EssenceType essenceType, Source source) {
        return this.contents.contains((Object)essenceType, (Object)source) ? (Integer)this.contents.get((Object)essenceType, (Object)source) : 0;
    }

    public int setEssenceCount(EssenceType type, Source source, int amount) {
        if (amount < 0) {
            return 0;
        }
        int capacity = this.getTotalEssenceCapacity();
        if (amount < capacity) {
            this.contents.put((Object)type, (Object)source, (Object)amount);
            return 0;
        }
        this.contents.put((Object)type, (Object)source, (Object)capacity);
        return amount - capacity;
    }

    public int getEssenceCountAtSlot(int index) {
        Source col;
        if (index < 0 || index >= NUM_SLOTS) {
            return 0;
        }
        EssenceType row = this.getEssenceTypeForIndex(index);
        return this.contents.contains((Object)row, (Object)(col = this.getEssenceSourceForIndex(index))) ? (Integer)this.contents.get((Object)row, (Object)col) : 0;
    }

    public void setEssenceCountAtSlot(int index, int count) {
        if (index < 0 || index >= NUM_SLOTS) {
            return;
        }
        EssenceType row = this.getEssenceTypeForIndex(index);
        Source col = this.getEssenceSourceForIndex(index);
        this.contents.put((Object)row, (Object)col, (Object)count);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadContentsNbt(compound);
    }

    protected void loadContentsNbt(CompoundTag compound) {
        this.contents.clear();
        CompoundTag contentsTag = compound.m_128469_("CaskContents");
        for (EssenceType type : EssenceType.values()) {
            CompoundTag typeContents = contentsTag.m_128469_(type.m_7912_());
            for (Source source : Source.SORTED_SOURCES) {
                int count = typeContents.m_128451_(source.getTag());
                this.contents.put((Object)type, (Object)source, (Object)count);
            }
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("CaskContents", (Tag)this.getContentsNbt());
    }

    protected CompoundTag getContentsNbt() {
        CompoundTag contentsTag = new CompoundTag();
        for (EssenceType type : EssenceType.values()) {
            CompoundTag typeContents = new CompoundTag();
            for (Source source : Source.SORTED_SOURCES) {
                int count = this.contents.contains((Object)type, (Object)source) ? (Integer)this.contents.get((Object)type, (Object)source) : 0;
                typeContents.m_128365_(source.getTag(), (Tag)IntTag.m_128679_((int)count));
            }
            contentsTag.m_128365_(type.m_7912_(), (Tag)typeContents);
        }
        return contentsTag;
    }

    public void dropContents() {
        this.dropContents(this.f_58857_, this.f_58858_);
        for (Table.Cell cell : this.contents.cellSet()) {
            ItemStack tempStack = EssenceItem.getEssence((EssenceType)((Object)cell.getRowKey()), (Source)cell.getColumnKey(), (Integer)cell.getValue());
            this.contents.put((Object)((EssenceType)((Object)cell.getRowKey())), (Object)((Source)cell.getColumnKey()), (Object)0);
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)tempStack);
        }
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0 -> 1;
            default -> 0;
        };
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP -> OptionalInt.of(0);
            default -> OptionalInt.empty();
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof EssenceItem;
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
    }
}

