/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ITileResearchCache;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.capabilities.TileResearchCache;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.essence.EssenceType;
import com.verdantartifice.primalmagick.common.menus.EssenceTransmuterMenu;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.sources.IManaContainer;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.util.ItemUtils;
import com.verdantartifice.primalmagick.common.util.WeightedRandomBag;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class EssenceTransmuterTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainer,
IOwnedTileEntity {
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int OUTPUT_INV_INDEX = 1;
    protected static final int WAND_INV_INDEX = 2;
    protected static final int ESSENCE_PER_TRANSMUTE = 8;
    protected static final int OUTPUT_CAPACITY = 9;
    protected int processTime;
    protected int processTimeTotal;
    protected UUID ownerUUID;
    protected ManaStorage manaStorage;
    protected ITileResearchCache researchCache;
    protected Source nextOutputSource;
    protected LazyOptional<IManaStorage> manaStorageOpt = LazyOptional.of(() -> this.manaStorage);
    protected LazyOptional<ITileResearchCache> researchCacheOpt = LazyOptional.of(() -> this.researchCache);
    protected Set<SimpleResearchKey> relevantResearch = Collections.emptySet();
    protected final Predicate<SimpleResearchKey> relevantFilter = k -> this.getRelevantResearch().contains(k);
    protected final ContainerData transmuterData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return EssenceTransmuterTileEntity.this.processTime;
                }
                case 1: {
                    return EssenceTransmuterTileEntity.this.processTimeTotal;
                }
                case 2: {
                    return EssenceTransmuterTileEntity.this.manaStorage.getManaStored(Source.MOON);
                }
                case 3: {
                    return EssenceTransmuterTileEntity.this.manaStorage.getMaxManaStored(Source.MOON);
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    EssenceTransmuterTileEntity.this.processTime = value;
                    break;
                }
                case 1: {
                    EssenceTransmuterTileEntity.this.processTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public EssenceTransmuterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.ESSENCE_TRANSMUTER.get(), pos, state);
        this.manaStorage = new ManaStorage(10000, 100, 100, Source.MOON);
        this.researchCache = new TileResearchCache();
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        String ownerUUIDStr;
        super.m_142466_(compound);
        this.processTime = compound.m_128451_("ProcessTime");
        this.processTimeTotal = compound.m_128451_("ProcessTimeTotal");
        this.manaStorage.deserializeNBT(compound.m_128469_("ManaStorage"));
        this.researchCache.deserializeNBT((Tag)compound.m_128469_("ResearchCache"));
        this.nextOutputSource = compound.m_128425_("NextSource", 8) ? Source.getSource(compound.m_128461_("NextSource")) : null;
        this.ownerUUID = null;
        if (compound.m_128441_("OwnerUUID") && !(ownerUUIDStr = compound.m_128461_("OwnerUUID")).isEmpty()) {
            this.ownerUUID = UUID.fromString(ownerUUIDStr);
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ProcessTime", this.processTime);
        compound.m_128405_("ProcessTimeTotal", this.processTimeTotal);
        compound.m_128365_("ManaStorage", (Tag)this.manaStorage.serializeNBT());
        compound.m_128365_("ResearchCache", this.researchCache.serializeNBT());
        if (this.nextOutputSource != null) {
            compound.m_128359_("NextSource", this.nextOutputSource.getTag());
        }
        if (this.ownerUUID != null) {
            compound.m_128359_("OwnerUUID", this.ownerUUID.toString());
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new EssenceTransmuterMenu(windowId, playerInv, this.m_58899_(), this, this.transmuterData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    protected int getProcessTimeTotal() {
        return 100;
    }

    protected int getManaCost() {
        return 10;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.f_46443_) {
            this.relevantResearch = EssenceTransmuterTileEntity.assembleRelevantResearch();
        }
        this.processTimeTotal = this.getProcessTimeTotal();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EssenceTransmuterTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.f_46443_) {
            ItemStack essenceStack;
            int centimanaMissing;
            int centimanaToTransfer;
            IWand wand;
            Item item;
            ItemStack wandStack = entity.getItem(2, 0);
            if (!wandStack.m_41619_() && (item = wandStack.m_41720_()) instanceof IWand && (wand = (IWand)item).consumeMana(wandStack, null, Source.MOON, centimanaToTransfer = Mth.m_14045_((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Source.MOON) - entity.manaStorage.getManaStored(Source.MOON)), (int)0, (int)100))) {
                entity.manaStorage.receiveMana(Source.MOON, centimanaToTransfer, false);
                shouldMarkDirty = true;
            }
            if (!(essenceStack = entity.getItem(0, 0)).m_41619_() && entity.manaStorage.getManaStored(Source.MOON) >= entity.getManaCost()) {
                if (entity.canTransmute(essenceStack)) {
                    ++entity.processTime;
                    if (entity.processTime == entity.processTimeTotal) {
                        entity.processTime = 0;
                        entity.processTimeTotal = entity.getProcessTimeTotal();
                        entity.doTransmute(essenceStack);
                        entity.nextOutputSource = null;
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.processTime = 0;
                }
            } else if (entity.processTime > 0) {
                entity.processTime = Mth.m_14045_((int)(entity.processTime - 2), (int)0, (int)entity.processTimeTotal);
            }
        }
        if (shouldMarkDirty) {
            entity.m_6596_();
            entity.syncTile(true);
        }
    }

    @Nonnull
    protected Source getNextSource(Source inputSource, RandomSource rng) {
        if (this.nextOutputSource == null || this.nextOutputSource.equals(inputSource)) {
            WeightedRandomBag<Source> bag = new WeightedRandomBag<Source>();
            for (Source source : Source.SOURCES.values()) {
                if (source.equals(inputSource) || !this.isSourceKnown(source)) continue;
                bag.add(source, 1.0);
            }
            this.nextOutputSource = (Source)bag.getRandom(rng);
        }
        return this.nextOutputSource;
    }

    protected boolean canTransmute(ItemStack inputStack) {
        List<ItemStack> newOutputs = this.getNewOutputs(inputStack);
        return newOutputs != null && newOutputs.size() <= 9;
    }

    protected void doTransmute(ItemStack inputStack) {
        List<ItemStack> newOutputs = this.getNewOutputs(inputStack);
        if (newOutputs != null) {
            for (int index = 0; index < Math.min(newOutputs.size(), 9); ++index) {
                ItemStack out = newOutputs.get(index);
                this.setItem(1, index, out == null ? ItemStack.f_41583_ : out);
            }
            inputStack.m_41774_(8);
            this.manaStorage.extractMana(Source.MOON, this.getManaCost(), false);
        }
    }

    @Nullable
    protected List<ItemStack> getNewOutputs(ItemStack inputStack) {
        Item item;
        if (inputStack != null && !inputStack.m_41619_() && inputStack.m_41613_() >= 8 && (item = inputStack.m_41720_()) instanceof EssenceItem) {
            EssenceItem essence = (EssenceItem)item;
            EssenceType inputType = essence.getEssenceType();
            Source inputSource = essence.getSource();
            Source outputSource = this.getNextSource(inputSource, this.f_58857_.f_46441_);
            ItemStack outputItem = EssenceItem.getEssence(inputType, outputSource, 1);
            List currentOutputs = (List)this.inventories.get(1);
            List<ItemStack> mergedOutputs = ItemUtils.mergeItemStackIntoList(currentOutputs, outputItem);
            return mergedOutputs;
        }
        return null;
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 0 && (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack))) {
            this.processTimeTotal = this.getProcessTimeTotal();
            this.processTime = 0;
            this.nextOutputSource = null;
            this.m_6596_();
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == PrimalMagickCapabilities.MANA_STORAGE) {
            return this.manaStorageOpt.cast();
        }
        if (!this.f_58859_ && cap == PrimalMagickCapabilities.RESEARCH_CACHE) {
            return this.researchCacheOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.manaStorageOpt.invalidate();
        this.researchCacheOpt.invalidate();
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Source.SORTED_SOURCES) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Source.MOON);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    public void setTileOwner(Player owner) {
        this.ownerUUID = owner.m_20148_();
        this.updateResearchCache(owner);
    }

    @Override
    public Player getTileOwner() {
        Level level;
        if (this.ownerUUID != null && this.m_58898_() && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer livePlayer = serverLevel.m_7654_().m_6846_().m_11259_(this.ownerUUID);
            if (livePlayer != null && livePlayer.f_19797_ % 20 == 0) {
                this.updateResearchCache((Player)livePlayer);
            }
            return livePlayer;
        }
        return null;
    }

    protected void updateResearchCache(Player player) {
        this.researchCache.update(player, this.relevantFilter);
        this.nextOutputSource = null;
    }

    protected boolean isSourceKnown(@Nullable Source source) {
        if (source == null || source.getDiscoverKey() == null) {
            return true;
        }
        Player owner = this.getTileOwner();
        if (owner != null) {
            return source.isDiscovered(owner);
        }
        return this.researchCache.isResearchComplete(source.getDiscoverKey());
    }

    protected Set<SimpleResearchKey> getRelevantResearch() {
        return this.relevantResearch;
    }

    protected static Set<SimpleResearchKey> assembleRelevantResearch() {
        return Source.SORTED_SOURCES.stream().map(s -> s.getDiscoverKey()).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 2 -> 1;
            case 1 -> 9;
            default -> 0;
        };
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP -> OptionalInt.of(0);
            case Direction.DOWN -> OptionalInt.of(1);
            default -> OptionalInt.of(2);
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_204117_(ItemTagsPM.ESSENCES);
            }
        });
        retVal.set(2, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(2), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof IWand;
            }
        });
        retVal.set(1, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(1), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
        for (int inputIndex = 0; inputIndex < 9; ++inputIndex) {
            this.setItem(1, inputIndex, (ItemStack)legacyItems.get(inputIndex + 1));
        }
        this.setItem(2, 0, (ItemStack)legacyItems.get(10));
    }
}

