/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.menus.HoneyExtractorMenu;
import com.verdantartifice.primalmagick.common.sources.IManaContainer;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class HoneyExtractorTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainer {
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int OUTPUT_INV_INDEX = 1;
    protected static final int WAND_INV_INDEX = 2;
    protected int spinTime;
    protected int spinTimeTotal;
    protected ManaStorage manaStorage;
    protected LazyOptional<IManaStorage> manaStorageOpt = LazyOptional.of(() -> this.manaStorage);
    protected final ContainerData extractorData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return HoneyExtractorTileEntity.this.spinTime;
                }
                case 1: {
                    return HoneyExtractorTileEntity.this.spinTimeTotal;
                }
                case 2: {
                    return HoneyExtractorTileEntity.this.manaStorage.getManaStored(Source.SKY);
                }
                case 3: {
                    return HoneyExtractorTileEntity.this.manaStorage.getMaxManaStored(Source.SKY);
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    HoneyExtractorTileEntity.this.spinTime = value;
                    break;
                }
                case 1: {
                    HoneyExtractorTileEntity.this.spinTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public HoneyExtractorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.HONEY_EXTRACTOR.get(), pos, state);
        this.manaStorage = new ManaStorage(10000, 100, 100, Source.SKY);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.spinTime = compound.m_128451_("SpinTime");
        this.spinTimeTotal = compound.m_128451_("SpinTimeTotal");
        this.manaStorage.deserializeNBT(compound.m_128469_("ManaStorage"));
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("SpinTime", this.spinTime);
        compound.m_128405_("SpinTimeTotal", this.spinTimeTotal);
        compound.m_128365_("ManaStorage", (Tag)this.manaStorage.serializeNBT());
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new HoneyExtractorMenu(windowId, playerInv, this.m_58899_(), this, this.extractorData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    protected int getSpinTimeTotal() {
        return 100;
    }

    protected int getManaCost() {
        return 10;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.spinTimeTotal = this.getSpinTimeTotal();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HoneyExtractorTileEntity entity) {
        boolean shouldMarkDirty = false;
        if (!level.f_46443_) {
            int centimanaMissing;
            int centimanaToTransfer;
            IWand wand;
            ItemStack wandStack = entity.getItem(2, 0);
            if (!wandStack.m_41619_() && wandStack.m_41720_() instanceof IWand && (wand = (IWand)wandStack.m_41720_()).consumeMana(wandStack, null, Source.SKY, centimanaToTransfer = Mth.m_14045_((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Source.SKY) - entity.manaStorage.getManaStored(Source.SKY)), (int)0, (int)100))) {
                entity.manaStorage.receiveMana(Source.SKY, centimanaToTransfer, false);
                shouldMarkDirty = true;
            }
            ItemStack honeycombStack = entity.getItem(0, 0);
            ItemStack bottleStack = entity.getItem(0, 1);
            if (!honeycombStack.m_41619_() && !bottleStack.m_41619_() && entity.manaStorage.getManaStored(Source.SKY) >= entity.getManaCost()) {
                if (entity.canSpin()) {
                    ++entity.spinTime;
                    if (entity.spinTime == entity.spinTimeTotal) {
                        entity.spinTime = 0;
                        entity.spinTimeTotal = entity.getSpinTimeTotal();
                        entity.doExtraction();
                        shouldMarkDirty = true;
                    }
                } else {
                    entity.spinTime = 0;
                }
            } else if (entity.spinTime > 0) {
                entity.spinTime = Mth.m_14045_((int)(entity.spinTime - 2), (int)0, (int)entity.spinTimeTotal);
            }
        }
        if (shouldMarkDirty) {
            entity.m_6596_();
            entity.syncTile(true);
        }
    }

    protected boolean canSpin() {
        ItemStack honeyOutput = this.getItem(1, 0);
        ItemStack beeswaxOutput = this.getItem(1, 1);
        return honeyOutput.m_41613_() < ((ItemStackHandler)this.itemHandlers.get(1)).getSlotLimit(0) && honeyOutput.m_41613_() < honeyOutput.m_41741_() && beeswaxOutput.m_41613_() < ((ItemStackHandler)this.itemHandlers.get(1)).getSlotLimit(1) && beeswaxOutput.m_41613_() < beeswaxOutput.m_41741_();
    }

    protected void doExtraction() {
        ItemStack honeycombStack = this.getItem(0, 0);
        ItemStack bottleStack = this.getItem(0, 1);
        if (!honeycombStack.m_41619_() && !bottleStack.m_41619_() && this.canSpin() && this.manaStorage.getManaStored(Source.SKY) >= this.getManaCost()) {
            ItemStack honeyStack = this.getItem(1, 0);
            if (honeyStack.m_41619_()) {
                this.setItem(1, 0, new ItemStack((ItemLike)Items.f_42787_));
            } else {
                honeyStack.m_41769_(1);
            }
            ItemStack beeswaxStack = this.getItem(1, 1);
            if (beeswaxStack.m_41619_()) {
                this.setItem(1, 1, new ItemStack((ItemLike)ItemsPM.BEESWAX.get()));
            } else {
                beeswaxStack.m_41769_(1);
            }
            honeycombStack.m_41774_(1);
            bottleStack.m_41774_(1);
            this.manaStorage.extractMana(Source.SKY, this.getManaCost(), false);
        }
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 0 && (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack))) {
            this.spinTimeTotal = this.getSpinTimeTotal();
            this.spinTime = 0;
            this.m_6596_();
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == PrimalMagickCapabilities.MANA_STORAGE) {
            return this.manaStorageOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.manaStorageOpt.invalidate();
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Source.SORTED_SOURCES) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Source.SKY);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 1 -> 2;
            case 2 -> 1;
            default -> 0;
        };
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP -> OptionalInt.of(0);
            case Direction.DOWN -> OptionalInt.of(1);
            default -> OptionalInt.of(2);
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot == 0) {
                    return stack.m_150930_(Items.f_42784_);
                }
                if (slot == 1) {
                    return stack.m_150930_(Items.f_42590_);
                }
                return false;
            }
        });
        retVal.set(2, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(2), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof IWand;
            }
        });
        retVal.set(1, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(1), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
        this.setItem(0, 1, (ItemStack)legacyItems.get(1));
        this.setItem(1, 0, (ItemStack)legacyItems.get(2));
        this.setItem(1, 1, (ItemStack)legacyItems.get(3));
        this.setItem(2, 0, (ItemStack)legacyItems.get(4));
    }
}

