/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.ManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.menus.InfernalFurnaceMenu;
import com.verdantartifice.primalmagick.common.sources.IManaContainer;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.wands.IWand;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class InfernalFurnaceTileEntity
extends AbstractTileSidedInventoryPM
implements MenuProvider,
IManaContainer,
RecipeHolder,
StackedContentsCompatible {
    protected static final int SUPERCHARGE_MULTIPLIER = 5;
    protected static final int MANA_PER_HALF_SECOND = 1;
    protected static final int DEFAULT_COOK_TIME = 100;
    protected static final int LIT_GRACE_TICKS_MAX = 5;
    protected static final int OUTPUT_INV_INDEX = 0;
    protected static final int INPUT_INV_INDEX = 1;
    protected static final int FUEL_INV_INDEX = 2;
    protected int superchargeTime;
    protected int superchargeTimeTotal;
    protected int processTime;
    protected int processTimeTotal;
    protected int litGraceTicks;
    protected ManaStorage manaStorage;
    protected LazyOptional<IManaStorage> manaStorageOpt = LazyOptional.of(() -> this.manaStorage);
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    protected final ContainerData furnaceData = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return InfernalFurnaceTileEntity.this.processTime;
                }
                case 1: {
                    return InfernalFurnaceTileEntity.this.processTimeTotal;
                }
                case 2: {
                    return InfernalFurnaceTileEntity.this.manaStorage.getManaStored(Source.INFERNAL);
                }
                case 3: {
                    return InfernalFurnaceTileEntity.this.manaStorage.getMaxManaStored(Source.INFERNAL);
                }
                case 4: {
                    return InfernalFurnaceTileEntity.this.superchargeTime;
                }
                case 5: {
                    return InfernalFurnaceTileEntity.this.superchargeTimeTotal;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    InfernalFurnaceTileEntity.this.processTime = value;
                    break;
                }
                case 1: {
                    InfernalFurnaceTileEntity.this.processTimeTotal = value;
                    break;
                }
                case 4: {
                    InfernalFurnaceTileEntity.this.superchargeTime = value;
                    break;
                }
                case 5: {
                    InfernalFurnaceTileEntity.this.superchargeTimeTotal = value;
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };

    public InfernalFurnaceTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.INFERNAL_FURNACE.get(), pos, state);
        this.manaStorage = new ManaStorage(10000, 100, 100, Source.INFERNAL);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.processTime = compound.m_128451_("ProcessTime");
        this.processTimeTotal = compound.m_128451_("ProcessTimeTotal");
        this.superchargeTime = compound.m_128451_("SuperchargeTime");
        this.superchargeTimeTotal = compound.m_128451_("SuperchargeTimeTotal");
        this.manaStorage.deserializeNBT(compound.m_128469_("ManaStorage"));
        CompoundTag recipesUsedTag = compound.m_128469_("RecipesUsed");
        for (String key : recipesUsedTag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(key), recipesUsedTag.m_128451_(key));
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ProcessTime", this.processTime);
        compound.m_128405_("ProcessTimeTotal", this.processTimeTotal);
        compound.m_128405_("SuperchargeTime", this.superchargeTime);
        compound.m_128405_("SuperchargeTimeTotal", this.superchargeTimeTotal);
        compound.m_128365_("ManaStorage", (Tag)this.manaStorage.serializeNBT());
        CompoundTag recipesUsedTag = new CompoundTag();
        this.recipesUsed.forEach((key, value) -> recipesUsedTag.m_128405_(key.toString(), value.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)recipesUsedTag);
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new InfernalFurnaceMenu(pContainerId, pPlayerInventory, this.m_58899_(), this, this.furnaceData);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    private boolean isLit() {
        return this.processTime > 0 || this.litGraceTicks > 0;
    }

    private boolean isCharged() {
        int current = this.getMana(Source.INFERNAL);
        return current > 0 && current >= InfernalFurnaceTileEntity.getManaNeeded(this.m_58904_(), this);
    }

    private boolean isSupercharged() {
        return this.superchargeTime > 0;
    }

    private static Optional<SmeltingRecipe> getActiveRecipe(Level level, InfernalFurnaceTileEntity entity) {
        SimpleContainer testInv = new SimpleContainer(new ItemStack[]{entity.getItem(1, 0)});
        return level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)testInv, level);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.processTimeTotal = InfernalFurnaceTileEntity.getTotalCookTime(this.f_58857_, this, 100);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, InfernalFurnaceTileEntity entity) {
        boolean fuelPopulated;
        int centimanaMissing;
        int centimanaToTransfer;
        IWand wand;
        Item item;
        ItemStack wandStack;
        boolean shouldMarkDirty = false;
        boolean startedLit = entity.isLit();
        entity.litGraceTicks = Mth.m_14045_((int)(entity.litGraceTicks - 1), (int)0, (int)5);
        if (!level.f_46443_ && !(wandStack = entity.getItem(2, 1)).m_41619_() && (item = wandStack.m_41720_()) instanceof IWand && (wand = (IWand)item).consumeMana(wandStack, null, Source.INFERNAL, centimanaToTransfer = Mth.m_14045_((int)(centimanaMissing = entity.manaStorage.getMaxManaStored(Source.INFERNAL) - entity.manaStorage.getManaStored(Source.INFERNAL)), (int)0, (int)100))) {
            entity.manaStorage.receiveMana(Source.INFERNAL, centimanaToTransfer, false);
            shouldMarkDirty = true;
        }
        if (entity.isSupercharged()) {
            --entity.superchargeTime;
        }
        ItemStack fuelStack = entity.getItem(2, 0);
        boolean inputPopulated = !entity.getItem(1, 0).m_41619_();
        boolean bl = fuelPopulated = !fuelStack.m_41619_();
        if (entity.isCharged() && inputPopulated) {
            Recipe recipe = InfernalFurnaceTileEntity.getActiveRecipe(level, entity).orElse(null);
            int furnaceMaxStackSize = ((ItemStackHandler)entity.itemHandlers.get(1)).getSlotLimit(0);
            if (!entity.isSupercharged() && fuelPopulated && InfernalFurnaceTileEntity.canBurn(level.m_9598_(), recipe, entity, furnaceMaxStackSize)) {
                entity.superchargeTime = entity.superchargeTimeTotal = entity.getSuperchargeDuration(fuelStack);
                if (entity.isSupercharged()) {
                    shouldMarkDirty = true;
                    if (fuelStack.hasCraftingRemainingItem()) {
                        entity.setItem(2, 0, fuelStack.getCraftingRemainingItem());
                    } else {
                        fuelStack.m_41774_(1);
                        if (fuelStack.m_41619_()) {
                            entity.setItem(2, 0, ItemStack.f_41583_);
                        }
                    }
                }
            }
            if (entity.isCharged() && InfernalFurnaceTileEntity.canBurn(level.m_9598_(), recipe, entity, furnaceMaxStackSize)) {
                entity.processTime = entity.processTime + (entity.isSupercharged() ? 5 : 1);
                if (entity.processTime >= entity.processTimeTotal) {
                    entity.processTime = 0;
                    entity.processTimeTotal = InfernalFurnaceTileEntity.getTotalCookTime(level, entity, 100);
                    entity.litGraceTicks = 5;
                    if (InfernalFurnaceTileEntity.burn(level.m_9598_(), recipe, entity, furnaceMaxStackSize)) {
                        entity.m_6029_(recipe);
                    }
                    shouldMarkDirty = true;
                }
            } else {
                entity.processTime = 0;
            }
        } else if (entity.processTime > 0) {
            entity.processTime = Mth.m_14045_((int)(entity.processTime - 2), (int)0, (int)entity.processTimeTotal);
        }
        if (startedLit != entity.isLit()) {
            shouldMarkDirty = true;
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(entity.isLit()));
            level.m_7731_(pos, state, 3);
        }
        if (shouldMarkDirty) {
            InfernalFurnaceTileEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private static boolean canBurn(RegistryAccess registryAccess, @Nullable Recipe<?> recipe, InfernalFurnaceTileEntity entity, int maxFurnaceStackSize) {
        if (!entity.getItem(1, 0).m_41619_() && recipe != null) {
            ItemStack recipeOutput = recipe.m_5874_((Container)new RecipeWrapper((IItemHandlerModifiable)entity.itemHandlers.get(1)), registryAccess);
            if (recipeOutput.m_41619_()) {
                return false;
            }
            ItemStack existingOutput = entity.getItem(0, 0);
            if (existingOutput.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)recipeOutput, (ItemStack)existingOutput)) {
                return false;
            }
            if (existingOutput.m_41613_() + recipeOutput.m_41613_() <= maxFurnaceStackSize && existingOutput.m_41613_() + recipeOutput.m_41613_() <= existingOutput.m_41741_()) {
                return true;
            }
            return existingOutput.m_41613_() + recipeOutput.m_41613_() <= recipeOutput.m_41741_();
        }
        return false;
    }

    private static boolean burn(RegistryAccess registryAccess, @Nullable Recipe<?> recipe, InfernalFurnaceTileEntity entity, int maxFurnaceStackSize) {
        if (recipe != null && InfernalFurnaceTileEntity.canBurn(registryAccess, recipe, entity, maxFurnaceStackSize)) {
            ItemStack inputStack = entity.getItem(1, 0);
            ItemStack recipeOutput = recipe.m_5874_((Container)new RecipeWrapper((IItemHandlerModifiable)entity.itemHandlers.get(1)), registryAccess);
            ItemStack existingOutput = entity.getItem(0, 0);
            if (existingOutput.m_41619_()) {
                entity.setItem(0, 0, recipeOutput.m_41777_());
            } else if (ItemStack.m_41656_((ItemStack)recipeOutput, (ItemStack)existingOutput)) {
                existingOutput.m_41769_(recipeOutput.m_41613_());
            }
            if (entity.manaStorage.canExtract(Source.INFERNAL)) {
                entity.manaStorage.extractMana(Source.INFERNAL, InfernalFurnaceTileEntity.getManaNeeded(entity.m_58904_(), entity), false);
            }
            inputStack.m_41774_(1);
            return true;
        }
        return false;
    }

    protected int getSuperchargeDuration(ItemStack pFuel) {
        if (pFuel.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)pFuel, (RecipeType)RecipeType.f_44108_) / 5;
    }

    private static int getTotalCookTime(Level pLevel, InfernalFurnaceTileEntity pBlockEntity, int defaultTime) {
        return InfernalFurnaceTileEntity.getActiveRecipe(pLevel, pBlockEntity).map(AbstractCookingRecipe::m_43753_).map(t -> t / 2).orElse(defaultTime);
    }

    private static int getManaNeeded(Level pLevel, InfernalFurnaceTileEntity pBlockEntity) {
        return pBlockEntity.getItem(1, 0).m_41619_() ? 0 : InfernalFurnaceTileEntity.getTotalCookTime(pLevel, pBlockEntity, 0) / 10 * 1;
    }

    public static boolean isSuperchargeFuel(ItemStack pStack) {
        return pStack.m_204117_(ItemTagsPM.INFERNAL_SUPERCHARGE_FUEL);
    }

    public void m_5809_(StackedContents pHelper) {
        for (int invIndex = 0; invIndex < this.getInventoryCount(); ++invIndex) {
            for (int slotIndex = 0; slotIndex < this.getInventorySize(invIndex); ++slotIndex) {
                pHelper.m_36491_(this.getItem(invIndex, slotIndex));
            }
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == PrimalMagickCapabilities.MANA_STORAGE) {
            return this.manaStorageOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.manaStorageOpt.invalidate();
    }

    @Override
    public int getMana(Source source) {
        return this.manaStorage.getManaStored(source);
    }

    @Override
    public SourceList getAllMana() {
        SourceList.Builder mana = SourceList.builder();
        for (Source source : Source.SORTED_SOURCES) {
            int amount = this.manaStorage.getManaStored(source);
            if (amount <= 0) continue;
            mana.with(source, amount);
        }
        return mana.build();
    }

    @Override
    public int getMaxMana() {
        return this.manaStorage.getMaxManaStored(Source.INFERNAL);
    }

    @Override
    public void setMana(Source source, int amount) {
        this.manaStorage.setMana(source, amount);
        this.m_6596_();
        this.syncTile(true);
    }

    @Override
    public void setMana(SourceList mana) {
        this.manaStorage.setMana(mana);
        this.m_6596_();
        this.syncTile(true);
    }

    public void m_6029_(Recipe<?> pRecipe) {
        if (pRecipe != null) {
            this.recipesUsed.addTo((Object)pRecipe.m_6423_(), 1);
        }
    }

    public Recipe<?> m_7928_() {
        return null;
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)this.getItem(invIndex, slotIndex), (ItemStack)stack);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 1 && !flag && this.m_58898_()) {
            this.processTimeTotal = InfernalFurnaceTileEntity.getTotalCookTime(this.f_58857_, this, 100);
            this.processTime = 0;
            this.m_6596_();
        }
    }

    public void m_58395_(Player player, List<ItemStack> stacks) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        List<Recipe<?>> recipes = this.getRecipesToAwardAndPopExperience(pPlayer.m_284548_(), pPlayer.m_20182_());
        pPlayer.m_7281_(recipes);
        recipes.stream().filter(Predicate.not(Objects::isNull)).forEach(r -> pPlayer.m_280300_(r, (List)this.inventories.get(1)));
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel pLevel, Vec3 pPopVec) {
        ArrayList retVal = new ArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            pLevel.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                retVal.add((Recipe<?>)recipe);
                InfernalFurnaceTileEntity.createExperience(pLevel, pPopVec, entry.getIntValue(), ((AbstractCookingRecipe)recipe).m_43750_());
            });
        }
        return retVal;
    }

    private static void createExperience(ServerLevel pLevel, Vec3 pPopVec, int pRecipeIndex, float pExperience) {
        int i = Mth.m_14143_((float)((float)pRecipeIndex * pExperience));
        float f = Mth.m_14187_((float)((float)pRecipeIndex * pExperience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)pLevel, (Vec3)pPopVec, (int)i);
    }

    @Override
    protected int getInventoryCount() {
        return 3;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return switch (inventoryIndex) {
            case 0, 1 -> 1;
            case 2 -> 2;
            default -> 0;
        };
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP -> OptionalInt.of(1);
            case Direction.DOWN -> OptionalInt.of(0);
            default -> OptionalInt.of(2);
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(1, (Object)new ItemStackHandlerPM((NonNullList<ItemStack>)((NonNullList)this.inventories.get(1)), (AbstractTilePM)this));
        retVal.set(2, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(2), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                if (slot == 0) {
                    return stack.m_204117_(ItemTagsPM.INFERNAL_SUPERCHARGE_FUEL);
                }
                if (slot == 1) {
                    return stack.m_41720_() instanceof IWand;
                }
                return false;
            }
        });
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
        this.setItem(1, 0, (ItemStack)legacyItems.get(1));
        this.setItem(2, 0, (ItemStack)legacyItems.get(2));
        this.setItem(2, 1, (ItemStack)legacyItems.get(3));
    }
}

