/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.blocks.devices.SanguineCrucibleBlock;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.items.misc.SanguineCoreItem;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.WandPoofPacket;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import java.awt.Color;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemStackHandler;

public class SanguineCrucibleTileEntity
extends AbstractTileSidedInventoryPM {
    protected static final int INPUT_INV_INDEX = 0;
    protected static final int FLUID_CAPACITY = 1000;
    protected static final int FLUID_DRAIN = 200;
    protected static final int CHARGE_MAX = 100;
    protected static final int SPAWN_RANGE = 4;
    protected int souls;
    protected int fluidAmount;
    protected int charge;
    protected int counter = 0;

    public SanguineCrucibleTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.SANGUINE_CRUCIBLE.get(), pos, state);
    }

    @Override
    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return inventoryIndex == 0 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.souls = compound.m_128451_("Souls");
        this.fluidAmount = compound.m_128451_("FluidAmount");
        this.charge = compound.m_128451_("Charge");
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Souls", this.souls);
        compound.m_128405_("FluidAmount", this.fluidAmount);
        compound.m_128405_("Charge", this.charge);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SanguineCrucibleTileEntity entity) {
        SanguineCoreItem core;
        ++entity.counter;
        if (entity.fluidAmount < 1000) {
            ++entity.fluidAmount;
        }
        if (entity.hasCore() && entity.fluidAmount >= 200 && (core = entity.getCoreItem()) != null && entity.souls >= core.getSoulsPerSpawn()) {
            ++entity.charge;
            if (entity.charge >= 100) {
                entity.charge = 0;
                entity.fluidAmount -= 200;
                entity.souls -= core.getSoulsPerSpawn();
                if (!level.f_46443_) {
                    if (!entity.getItem(0, 0).m_41763_() || entity.getItem(0, 0).m_220157_(1, level.f_46441_, null)) {
                        entity.getItem(0, 0).m_41774_(1);
                        entity.updateLitState();
                    }
                    int attempts = 0;
                    boolean success = false;
                    while (attempts++ < 50 && !success) {
                        success = entity.attemptSpawn(core.getEntityType());
                    }
                    PacketHandler.sendToAllAround(new WandPoofPacket(pos.m_7494_(), Color.WHITE.getRGB(), true, Direction.UP), (ResourceKey<Level>)level.m_46472_(), pos, 32.0);
                    entity.m_6596_();
                    entity.syncTile(true);
                }
            }
        }
    }

    protected void updateLitState() {
        if (this.m_58898_()) {
            this.m_58904_().m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)SanguineCrucibleBlock.LIT, (Comparable)Boolean.valueOf(!this.getItem().m_41619_())), 11);
        }
    }

    protected boolean attemptSpawn(EntityType<?> entityType) {
        if (this.f_58857_.f_46443_) {
            return false;
        }
        double x = (double)this.f_58858_.m_123341_() + 4.0 * (this.f_58857_.f_46441_.m_188500_() - this.f_58857_.f_46441_.m_188500_()) + 0.5;
        double y = (double)this.f_58858_.m_123342_() + (double)this.f_58857_.f_46441_.m_188503_(3) - 1.0;
        double z = (double)this.f_58858_.m_123343_() + 4.0 * (this.f_58857_.f_46441_.m_188500_() - this.f_58857_.f_46441_.m_188500_()) + 0.5;
        BlockPos spawnPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (this.f_58857_.m_45772_(entityType.m_20585_(x, y, z))) {
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            Entity entity = entityType.m_20592_(serverWorld, (ItemStack)null, (Player)null, spawnPos, MobSpawnType.SPAWNER, true, !Objects.equals(this.f_58858_, spawnPos));
            if (entity == null) {
                return false;
            }
            entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.f_58857_.f_46441_.m_188501_() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                Mob mobEntity = (Mob)entity;
                ForgeEventFactory.onFinalizeSpawn((Mob)mobEntity, (ServerLevelAccessor)serverWorld, (DifficultyInstance)this.f_58857_.m_6436_(entity.m_20183_()), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
            }
            PacketHandler.sendToAllAround(new WandPoofPacket(x, y, z, Color.WHITE.getRGB(), true, Direction.UP), (ResourceKey<Level>)this.f_58857_.m_46472_(), entity.m_20183_(), 32.0);
            return true;
        }
        return false;
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        if (invIndex == 0 && (stack.m_41619_() || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack))) {
            this.charge = 0;
            this.m_6596_();
            this.syncTile(false);
        }
    }

    public int getSouls() {
        return this.souls;
    }

    public void addSouls(int count) {
        this.souls += count;
        this.m_6596_();
        this.syncTile(false);
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public float getFluidHeight() {
        return 0.3f + 0.5f * ((float)this.getFluidAmount() / 1000.0f);
    }

    public int getCharge() {
        return this.charge;
    }

    public double getSmokeChance() {
        return (double)this.charge / 100.0;
    }

    public boolean hasCore() {
        return !this.getItem(0, 0).m_41619_();
    }

    public boolean showBubble(RandomSource rand) {
        return rand.m_188499_() && this.counter % 5 == 0;
    }

    @Nullable
    protected SanguineCoreItem getCoreItem() {
        ItemStack stack = this.f_58857_.f_46443_ ? this.getSyncedItem(0, 0) : this.getItem(0, 0);
        Item item = stack.m_41720_();
        if (item instanceof SanguineCoreItem) {
            SanguineCoreItem core = (SanguineCoreItem)item;
            return core;
        }
        return null;
    }

    public ItemStack getItem() {
        return this.getItem(0, 0);
    }

    public void setItem(ItemStack stack) {
        this.setItem(0, 0, stack);
    }

    public ItemStack removeItem(int count) {
        ItemStack stack = ((ItemStackHandler)this.itemHandlers.get(0)).extractItem(0, count, false);
        if (!stack.m_41619_()) {
            this.syncSlots(null);
        }
        this.m_6596_();
        return stack;
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return inventoryIndex == 0 ? 1 : 0;
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return switch (face) {
            case Direction.UP, Direction.DOWN -> OptionalInt.empty();
            default -> OptionalInt.of(0);
        };
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof SanguineCoreItem;
            }

            @Override
            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                SanguineCrucibleTileEntity.this.updateLitState();
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
    }
}

