/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.verdantartifice.primalmagick.common.blocks.devices.SunlampBlock;
import com.verdantartifice.primalmagick.common.blocks.misc.GlowFieldBlock;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.util.RayTraceUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class SunlampTileEntity
extends AbstractTilePM {
    protected int ticksExisted = 0;

    public SunlampTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.SUNLAMP.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SunlampTileEntity entity) {
        ++entity.ticksExisted;
        if (!level.f_46443_ && entity.ticksExisted % 5 == 0) {
            Block block;
            int x = level.f_46441_.m_188503_(16) - level.f_46441_.m_188503_(16);
            int y = level.f_46441_.m_188503_(16) - level.f_46441_.m_188503_(16);
            int z = level.f_46441_.m_188503_(16) - level.f_46441_.m_188503_(16);
            BlockPos bp = pos.m_7918_(x, y, z);
            BlockPos rainHeight = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, bp);
            if (bp.m_123342_() > rainHeight.m_123342_() + 4) {
                bp = rainHeight.m_6630_(4);
            }
            if (bp.m_123342_() < 1) {
                bp = new BlockPos(bp.m_123341_(), 1, bp.m_123343_());
            }
            if ((block = state.m_60734_()) instanceof SunlampBlock) {
                GlowFieldBlock glowBlock = ((SunlampBlock)block).getGlowField();
                if (level.m_46859_(bp) && level.m_8055_(bp) != glowBlock.m_49966_() && level.m_45517_(LightLayer.BLOCK, bp) < 11 && RayTraceUtils.hasLineOfSight(level, pos, bp)) {
                    level.m_7731_(bp, glowBlock.m_49966_(), 3);
                }
            }
        }
    }
}

