/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.devices;

import com.verdantartifice.primalmagick.common.blocks.devices.AbstractWindGeneratorBlock;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WindGeneratorTileEntity
extends AbstractTilePM {
    public WindGeneratorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.WIND_GENERATOR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WindGeneratorTileEntity entity) {
        Block block = state.m_60734_();
        if (block instanceof AbstractWindGeneratorBlock) {
            AbstractWindGeneratorBlock block2 = (AbstractWindGeneratorBlock)block;
            if (((Boolean)state.m_61143_((Property)AbstractWindGeneratorBlock.POWERED)).booleanValue()) {
                int lineOfSightPower;
                int power = level.m_277086_(pos);
                Direction facing = (Direction)state.m_61143_((Property)AbstractWindGeneratorBlock.FACING);
                if (power < 1) {
                    return;
                }
                for (lineOfSightPower = 0; lineOfSightPower < power && level.m_46859_(pos.m_5484_(facing, lineOfSightPower + 1)); ++lineOfSightPower) {
                }
                Direction windDir = block2.getWindDirection(state);
                Vec3 windStep = new Vec3(windDir.m_253071_()).m_82490_(0.1 * ((double)power / 15.0));
                AABB zone = new AABB(pos).m_82369_(new Vec3(facing.m_253071_()).m_82490_((double)lineOfSightPower));
                List affected = level.m_6443_(Entity.class, zone, e -> !e.m_5833_() && (e instanceof ItemEntity || e instanceof LivingEntity));
                for (Entity affectedEntity : affected) {
                    affectedEntity.m_20256_(affectedEntity.m_20184_().m_82549_(windStep));
                }
            }
        }
    }
}

