/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.verdantartifice.primalmagick.common.blocks.mana.AbstractManaFontBlock;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.fx.ManaSparklePacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTilePM;
import com.verdantartifice.primalmagick.common.wands.IInteractWithWand;
import com.verdantartifice.primalmagick.common.wands.IWand;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractManaFontTileEntity
extends AbstractTilePM
implements IInteractWithWand {
    protected static final int RECHARGE_TICKS = 20;
    protected int ticksExisted = 0;
    protected int mana = this.getInitialMana();

    public AbstractManaFontTileEntity(BlockEntityType<? extends AbstractManaFontTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.mana = compound.m_128448_("mana");
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128376_("mana", (short)this.mana);
    }

    public int getMana() {
        return this.mana;
    }

    public int getManaCapacity() {
        int n;
        Block block = this.m_58900_().m_60734_();
        if (block instanceof AbstractManaFontBlock) {
            AbstractManaFontBlock fontBlock = (AbstractManaFontBlock)block;
            n = fontBlock.getManaCapacity();
        } else {
            n = 0;
        }
        return n;
    }

    protected abstract int getInitialMana();

    @Override
    public InteractionResult onWandRightClick(ItemStack wandStack, Level world, Player player, BlockPos pos, Direction direction) {
        Item item = wandStack.m_41720_();
        if (item instanceof IWand) {
            IWand wand = (IWand)item;
            wand.setPositionInUse(wandStack, this.m_58899_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void onWandUseTick(ItemStack wandStack, Level level, Player player, Vec3 targetPos, int count) {
        if (count % 5 == 0) {
            this.doSiphon(wandStack, level, player, targetPos);
        }
    }

    public void doSiphon(ItemStack wandStack, Level level, Player player, Vec3 targetPos) {
        Item item = wandStack.m_41720_();
        if (item instanceof IWand) {
            int tap;
            int leftover;
            AbstractManaFontBlock fontBlock;
            Source source;
            IWand wand = (IWand)item;
            Block block = this.m_58900_().m_60734_();
            if (block instanceof AbstractManaFontBlock && (source = (fontBlock = (AbstractManaFontBlock)block).getSource()) != null && (leftover = wand.addRealMana(wandStack, source, tap = Math.min(this.mana, wand.getSiphonAmount(wandStack)))) < tap) {
                this.mana -= tap - leftover;
                StatsManager.incrementValue(player, StatsPM.MANA_SIPHONED, tap - leftover);
                this.m_6596_();
                this.syncTile(true);
                if (!level.f_46443_) {
                    PacketHandler.sendToAllAround(new ManaSparklePacket(this.f_58858_, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 20, source.getColor()), (ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_, 32.0);
                }
            }
        }
    }

    public void doSiphon(IManaStorage container, Level level, Player player, Vec3 targetPos, int maxTransferCentimana) {
        int tap;
        int realManaTransfered;
        AbstractManaFontBlock fontBlock;
        Source source;
        Block block = this.m_58900_().m_60734_();
        if (block instanceof AbstractManaFontBlock && (source = (fontBlock = (AbstractManaFontBlock)block).getSource()) != null && (realManaTransfered = container.receiveMana(source, (tap = Math.min(this.mana, maxTransferCentimana / 100)) * 100, false) / 100) > 0) {
            this.mana -= realManaTransfered;
            StatsManager.incrementValue(player, StatsPM.MANA_SIPHONED, realManaTransfered);
            this.m_6596_();
            this.syncTile(true);
            if (!level.f_46443_) {
                PacketHandler.sendToAllAround(new ManaSparklePacket(this.f_58858_, targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 20, source.getColor()), (ResourceKey<Level>)this.f_58857_.m_46472_(), this.f_58858_, 32.0);
            }
        }
    }

    protected void doRecharge() {
        ++this.mana;
        if (this.mana > this.getManaCapacity()) {
            this.mana = this.getManaCapacity();
        } else {
            this.m_6596_();
            this.syncTile(true);
        }
    }
}

