/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.verdantartifice.primalmagick.common.blocks.mana.AncientManaFontBlock;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.ResearchName;
import com.verdantartifice.primalmagick.common.research.ResearchNames;
import com.verdantartifice.primalmagick.common.research.SimpleResearchKey;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.mana.AbstractManaFontTileEntity;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.common.util.InventoryUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AncientManaFontTileEntity
extends AbstractManaFontTileEntity {
    public AncientManaFontTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractManaFontTileEntity>)((BlockEntityType)TileEntityTypesPM.ANCIENT_MANA_FONT.get()), pos, state);
    }

    @Override
    protected int getInitialMana() {
        return this.getManaCapacity();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AncientManaFontTileEntity entity) {
        ++entity.ticksExisted;
        if (!level.f_46443_ && entity.ticksExisted % 10 == 0) {
            SimpleResearchKey shrineResearch = ((ResearchName)ResearchNames.INTERNAL_FOUND_SHRINE.get()).simpleKey();
            SimpleResearchKey siphonResearch = ((ResearchName)ResearchNames.INTERNAL_SIPHON_PROMPT.get()).simpleKey();
            List<Player> players = EntityUtils.getEntitiesInRange(level, pos, null, Player.class, 5.0);
            for (Player player : players) {
                Block block;
                if (!ResearchManager.isResearchComplete(player, shrineResearch) && !ResearchManager.isResearchComplete(player, SimpleResearchKey.FIRST_STEPS)) {
                    ResearchManager.completeResearch(player, shrineResearch);
                    player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.found_shrine").m_130940_(ChatFormatting.GREEN));
                }
                if (!ResearchManager.isResearchComplete(player, siphonResearch) && InventoryUtils.isPlayerCarrying(player, new ItemStack((ItemLike)ItemsPM.MUNDANE_WAND.get()))) {
                    ResearchManager.completeResearch(player, siphonResearch);
                    player.m_213846_((Component)Component.m_237115_((String)"event.primalmagick.siphon_prompt").m_130940_(ChatFormatting.GREEN));
                }
                if (!((block = state.m_60734_()) instanceof AncientManaFontBlock)) continue;
                AncientManaFontBlock fontBlock = (AncientManaFontBlock)block;
                StatsManager.discoverShrine(player, fontBlock.getSource(), pos);
            }
        }
        if (!level.f_46443_ && entity.ticksExisted % 20 == 0) {
            entity.doRecharge();
        }
    }
}

