/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.tiles.mana;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.blocks.mana.AbstractManaFontBlock;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.capabilities.ItemStackHandlerPM;
import com.verdantartifice.primalmagick.common.capabilities.PrimalMagickCapabilities;
import com.verdantartifice.primalmagick.common.tiles.TileEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.AbstractTileSidedInventoryPM;
import com.verdantartifice.primalmagick.common.tiles.mana.AbstractManaFontTileEntity;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;

public class AutoChargerTileEntity
extends AbstractTileSidedInventoryPM {
    protected static final int INPUT_INV_INDEX = 0;
    protected final Set<BlockPos> fontLocations = new HashSet<BlockPos>();
    protected int chargeTime;

    public AutoChargerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityTypesPM.AUTO_CHARGER.get(), pos, state);
    }

    @Override
    protected Set<Integer> getSyncedSlotIndices(int inventoryIndex) {
        return inventoryIndex == 0 ? ImmutableSet.of((Object)0) : ImmutableSet.of();
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.chargeTime = compound.m_128451_("ChargeTime");
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ChargeTime", this.chargeTime);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AutoChargerTileEntity entity) {
        ItemStack chargeStack = entity.getItem(0, 0);
        if (!level.f_46443_) {
            if (entity.chargeTime % 20 == 0) {
                entity.scanSurroundings();
            }
            Vec3 chargerCenter = Vec3.m_82512_((Vec3i)pos);
            for (BlockPos fontPos : entity.fontLocations) {
                BlockEntity blockEntity = level.m_7702_(fontPos);
                if (!(blockEntity instanceof AbstractManaFontTileEntity)) continue;
                AbstractManaFontTileEntity tile = (AbstractManaFontTileEntity)blockEntity;
                if (chargeStack.m_41720_() instanceof IWand) {
                    tile.onWandUseTick(chargeStack, level, null, chargerCenter, entity.chargeTime);
                    continue;
                }
                chargeStack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).ifPresent(manaCap -> {
                    if (entity.chargeTime % 5 == 0) {
                        tile.doSiphon((IManaStorage)manaCap, level, null, chargerCenter, 100);
                    }
                });
            }
            ++entity.chargeTime;
        }
    }

    protected void scanSurroundings() {
        BlockPos pos = this.m_58899_();
        if (this.f_58857_.isAreaLoaded(pos, 5)) {
            this.fontLocations.clear();
            Iterable positions = BlockPos.m_121940_((BlockPos)pos.m_7918_(-5, -5, -5), (BlockPos)pos.m_7918_(5, 5, 5));
            for (BlockPos searchPos : positions) {
                if (!(this.f_58857_.m_8055_(searchPos).m_60734_() instanceof AbstractManaFontBlock)) continue;
                this.fontLocations.add(searchPos.m_7949_());
            }
        }
    }

    public ItemStack getItem() {
        return this.getItem(0, 0);
    }

    public ItemStack getSyncedStack() {
        return (ItemStack)((NonNullList)this.syncedInventories.get(0)).get(0);
    }

    public void setItem(ItemStack stack) {
        this.setItem(0, 0, stack);
    }

    @Override
    public void setItem(int invIndex, int slotIndex, ItemStack stack) {
        boolean flag;
        ItemStack slotStack = this.getItem(invIndex, slotIndex);
        super.setItem(invIndex, slotIndex, stack);
        boolean bl = flag = !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack);
        if (invIndex == 0 && !flag) {
            this.chargeTime = 0;
            this.m_6596_();
        }
    }

    @Override
    protected int getInventoryCount() {
        return 1;
    }

    @Override
    protected int getInventorySize(int inventoryIndex) {
        return inventoryIndex == 0 ? 1 : 0;
    }

    @Override
    protected OptionalInt getInventoryIndexForFace(Direction face) {
        return OptionalInt.of(0);
    }

    @Override
    protected NonNullList<ItemStackHandler> createHandlers() {
        NonNullList retVal = NonNullList.m_122780_((int)this.getInventoryCount(), (Object)((Object)new ItemStackHandlerPM(this)));
        retVal.set(0, (Object)new ItemStackHandlerPM((NonNullList)this.inventories.get(0), this){

            public boolean isItemValid(int slot, ItemStack stack) {
                return stack.m_41720_() instanceof IWand || stack.getCapability(PrimalMagickCapabilities.MANA_STORAGE).isPresent();
            }
        });
        return retVal;
    }

    @Override
    protected void loadLegacyItems(NonNullList<ItemStack> legacyItems) {
        this.setItem(0, 0, (ItemStack)legacyItems.get(0));
    }
}

